/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.PasswordTextInput;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;
import org.tp23.antinstaller.renderer.text.ValidatedTextInputRenderer;

public class PasswordTextInputRenderer
extends ValidatedTextInputRenderer
implements TextOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");

    public void setContext(InstallerContext ctx) {
        this.ctx = ctx;
    }

    public void renderOutput(OutputField field, BufferedReader reader, PrintStream out) throws IOException {
        PasswordTextInput iField = (PasswordTextInput)field;
        StringBuffer displayText = new StringBuffer();
        displayText.append(field.getDisplayText());
        displayText.append("   [");
        displayText.append(res.getString("_default_"));
        displayText.append(":");
        displayText.append(iField.getDefaultValue());
        displayText.append("]");
        String input = null;
        if (OutputField.isTrue(iField.getTextMask())) {
            input = new PasswordField().getPassword(displayText.toString());
            System.out.print("\r                                                      ");
        } else {
            out.println(displayText.toString());
            input = reader.readLine();
        }
        out.println();
        out.println();
        if (input == null || input.equals("")) {
            input = iField.getDefaultValue();
        }
        iField.setInputResult(input);
    }

    public void renderError(OutputField field, BufferedReader reader, PrintStream out) throws IOException {
        out.println(this.getErrorMessage());
        this.renderOutput(field, reader, out);
    }

    public boolean isAbort() {
        return false;
    }

    protected String getErrorMessage() {
        return res.getString("notCorrectPasswordFormat");
    }

    public class PasswordField {
        String getPassword(String prompt) throws IOException {
            StringBuffer password = new StringBuffer();
            MaskingThread maskingthread = new MaskingThread(prompt);
            Thread thread = new Thread(maskingthread);
            thread.start();
            while (true) {
                char c = (char)System.in.read();
                maskingthread.stopMasking();
                if (c == '\r') {
                    c = (char)System.in.read();
                    if (c != '\n') continue;
                    break;
                }
                if (c == '\n') break;
                password.append(c);
            }
            return password.toString();
        }
    }

    class MaskingThread
    extends Thread {
        private boolean stop = false;
        private int index;
        private String prompt;

        public MaskingThread(String prompt) {
            this.prompt = prompt;
        }

        public void run() {
            while (!this.stop) {
                try {
                    MaskingThread.sleep(1L);
                }
                catch (InterruptedException iex) {
                    iex.printStackTrace();
                }
                if (!this.stop) {
                    System.out.print("\r" + this.prompt + " \r" + this.prompt);
                }
                System.out.flush();
            }
        }

        public void stopMasking() {
            this.stop = true;
        }
    }
}

