/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.TargetInput;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class TargetInputRenderer
implements TextOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");
    protected InstallerContext ctx;

    public void setContext(InstallerContext ctx) {
        this.ctx = ctx;
    }

    public void renderOutput(OutputField field, BufferedReader reader, PrintStream out) throws IOException {
        TargetInput iField = (TargetInput)field;
        out.println("Install the following component?");
        out.print(iField.getDisplayText());
        out.print("   [");
        out.print(res.getString("_default_"));
        out.print(":");
        out.print(iField.getDefaultValue());
        out.print("]");
        if (InputField.isTrue(iField.getForce())) {
            out.print("   [");
            out.print(res.getString("_required_"));
            out.println("]");
            this.ctx.getCurrentPage().addTarget(iField.getIdx(), iField.getTarget());
            iField.setInputResult("true");
            out.println();
            return;
        }
        out.println();
        String input = reader.readLine();
        out.println();
        if (input == null || input.trim().equals("")) {
            input = iField.getDefaultValue();
        }
        if (InputField.isTrue(input)) {
            this.ctx.getCurrentPage().addTarget(iField.getIdx(), iField.getTarget());
            iField.setInputResult("true");
        } else {
            this.ctx.getCurrentPage().removeTarget(iField.getIdx());
            iField.setInputResult("false");
        }
    }

    public boolean isAbort() {
        return false;
    }

    public void renderError(OutputField field, BufferedReader reader, PrintStream out) {
    }
}

