/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.anttasks;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.jetspeed.anttasks.StartDerby;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.JDBCTask;

public class StartDatabase
extends JDBCTask {
    @Override
    public void execute() throws BuildException {
        if (StartDerby.getDriver(this.getProject()) == null) {
            throw new BuildException("Derby driver not established!", this.getLocation());
        }
        if (StartDerby.getConnection(this.getProject()) != null) {
            System.out.println("Connection already established");
            return;
        }
        if (this.getUrl() == null) {
            throw new BuildException("Url attribute must be set!", this.getLocation());
        }
        try {
            Connection conn;
            this.log("connecting to " + this.getUrl(), 3);
            Properties info = new Properties();
            if (this.getUserId() != null) {
                info.put("user", this.getUserId());
            }
            if (this.getPassword() != null) {
                info.put("password", this.getPassword());
            }
            if ((conn = StartDerby.getDriver(this.getProject()).connect(this.getUrl(), info)) == null) {
                throw new SQLException("No suitable Driver for " + this.getUrl());
            }
            conn.setAutoCommit(this.isAutocommit());
            StartDerby.setConnection(this.getProject(), conn);
            System.out.println("Derby connected to " + this.getUrl());
            return;
        }
        catch (SQLException e) {
            throw new BuildException(e, this.getLocation());
        }
    }
}

