/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.portlets.wicket.component;

import org.apache.wicket.AttributeModifier;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

/**
 * @author <a href="mailto:vkumar@apache.org">Vivek Kumar</a>
 * @version $Id$
 */
public class JavascriptEventConfirmation extends AttributeModifier
{
    public JavascriptEventConfirmation(String event, String msg)
    {
        super(event, true, new Model(msg));
    }

    public JavascriptEventConfirmation(String event, IModel<?> msgModel)
    {
        super(event, true, msgModel);
    }

    protected String newValue(final String currentValue, final String replacementValue)
    {
        String prefix = "var conf = confirm('" + replacementValue + "'); " + "if (!conf) return false; ";
        String result = prefix;
        if (currentValue != null)
        {
            result = prefix + currentValue;
        }
        return result;
    }
}