package org.apache.jetspeed.portlet;

/**
 ** The <CODE>PortletLog</CODE> provides the portlet with the ability
 ** to log information, warning, or error texts. The log is
 ** maintained by the portlet container. The type and location of
 ** of the log is a matter of implementation. Also, whether logging
 ** is enabled or not is at the discretion of the portlet container.
 **
 ** <PRE>
 ** ...
 **
 ** PortletLog log = iContext.getLog ();
 **
 ** if (log.isWarnEnabled())
 **     log.warn ("Can access the content source");
 **
 ** ...
 ** </PRE>
 **
 ** @author   <A HREF="mailto:tboehme@apache.org">Thomas F. Boehme</A>
 **/

public interface PortletLog
{
    /**
     ** Returns whether the debug level of the portlet log is enabled.
     **
     ** @return   <CODE>true</CODE> if the log is enabled, <BR>
     **           <CODE>false</CODE>
     **/

    public boolean isDebugEnabled ();

    /**
     ** Logs the given informational text in the portlet log.
     **
     ** @param   text
     **          the informational text to log
     **/

    public void debug (String text);

    /**
     ** Returns whether the info level of the portlet log is enabled.
     **
     ** @return   <CODE>true</CODE> if the log is enabled, <BR>
     **           <CODE>false</CODE>
     **/

    public boolean isInfoEnabled ();

    /**
     ** Logs the given informational text in the portlet log.
     **
     ** @param   text
     **          the informational text to log
     **/

    public void info (String text);

    /**
     ** Returns whether the warn level of the portlet log is enabled.
     **
     ** @return   <CODE>true</CODE> if the log is enabled, <BR>
     **           <CODE>false</CODE>
     **/

    public boolean isWarnEnabled ();

    /**
     ** Logs the given warning text in the portlet log.
     **
     ** @param   text
     **          the warning text to log
     **/

    public void warn (String text);

    /**
     ** Returns whether the error level of the portlet log is enabled.
     **
     ** @return   <CODE>true</CODE> if the log is enabled, <BR>
     **           <CODE>false</CODE>
     **/

    public boolean isErrorEnabled ();

    /**
     ** Logs the given error text in the portlet log.
     **
     ** @param   text
     **          the error text to log
     **
     ** @see   #error(String,Throwable)
     **/

    public void error (String text);

    /**
     ** Logs the given error text, cause, and a stack trace in
     ** the portlet log.
     **
     ** @param   text
     **          the error text to log
     ** @param   cause
     **          the cause for logging
     **
     ** @see   #error(String)
     **/

    public void error (String text, Throwable cause);
}
