package org.apache.jetspeed.portlet;

/**
 ** Use the <CODE>UnavailableException</CODE> when the instantiation
 ** of a portlet fails.
 **
 ** @see   Portlet#init(PortletConfig)
 **
 ** @author   <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 **/

public class UnavailableException extends PortletException
{
    private Portlet     portlet;           // what's unavailable
    private boolean     permanent;         // needs admin action?
    private int         seconds;           // unavailability estimate

    /**
     * 
     * @deprecated	As of Java Portlet API 2.2, use {@link
     * 			#UnavailableException(String)} instead.
     *
     * @param portlet 	the <code>Portlet</code> instance that is
     *                  unavailable
     *
     * @param msg 	a <code>String</code> specifying the
     *                  descriptive message
     *
     */

    public UnavailableException(Portlet portlet, String msg) {
	super(msg);
	this.portlet = portlet;
	permanent = true;
    }
 
    /**
     * @deprecated	As of Java Portlet API 2.2, use {@link
     *			#UnavailableException(String, int)} instead.
     *
     * @param seconds	an integer specifying the number of seconds
     * 			the portlet expects to be unavailable; if
     *			zero or negative, indicates that the portlet
     *			can't make an estimate
     *
     * @param portlet	the <code>Portlet</code> that is unavailable
     * 
     * @param msg	a <code>String</code> specifying the descriptive 
     *			message, which can be written to a log file or 
     *			displayed for the user.
     *
     */
    
    public UnavailableException(int seconds, Portlet portlet, String msg) {
	super(msg);
	this.portlet = portlet;
	if (seconds <= 0)
	    this.seconds = -1;
	else
	    this.seconds = seconds;
	permanent = false;
    }

    /**
     * 
     * Constructs a new exception with a descriptive
     * message indicating that the portlet is permanently
     * unavailable.
     *
     * @param msg 	a <code>String</code> specifying the
     *                  descriptive message
     *
     */

    public UnavailableException(String msg) {
	super(msg);

	permanent = true;
    }

    /**
     * Constructs a new exception with a descriptive message
     * indicating that the portlet is temporarily unavailable
     * and giving an estimate of how long it will be unavailable.
     * 
     * <p>In some cases, the portlet cannot make an estimate. For
     * example, the portlet might know that a server it needs is
     * not running, but not be able to report how long it will take
     * to be restored to functionality. This can be indicated with
     * a negative or zero value for the <code>seconds</code> argument.
     *
     * @param msg	a <code>String</code> specifying the
     *                  descriptive message, which can be written
     *                  to a log file or displayed for the user.
     *
     * @param seconds	an integer specifying the number of seconds
     * 			the portlet expects to be unavailable; if
     *			zero or negative, indicates that the portlet
     *			can't make an estimate
     *
     */
    
    public UnavailableException(String msg, int seconds) {
	super(msg);

	if (seconds <= 0)
	    this.seconds = -1;
	else
	    this.seconds = seconds;

	permanent = false;
    }

    /**
     *
     * Returns a <code>boolean</code> indicating
     * whether the portlet is permanently unavailable.
     * If so, something is wrong with the portlet, and the
     * system administrator must take some corrective action.
     *
     * @return		<code>true</code> if the portlet is
     *			permanently unavailable; <code>false</code>
     *			if the portlet is available or temporarily
     *			unavailable
     *
     */
     
    public boolean isPermanent() {
	return permanent;
    }
  
    /**
     * @deprecated	As of Java Portlet API 2.2, with no replacement.
     *
     * Returns the portlet that is reporting its unavailability.
     * 
     * @return		the <code>Portlet</code> object that is 
     *			throwing the <code>UnavailableException</code>
     *
     */
     
    public Portlet getPortlet() {
	return portlet;
    }

    /**
     * Returns the number of seconds the portlet expects to 
     * be temporarily unavailable.  
     *
     * <p>If this method returns a negative number, the portlet
     * is permanently unavailable or cannot provide an estimate of
     * how long it will be unavailable. No effort is
     * made to correct for the time elapsed since the exception was
     * first reported.
     *
     * @return		an integer specifying the number of seconds
     *			the portlet will be temporarily unavailable,
     *			or a negative number if the portlet is permanently
     *			unavailable or cannot make an estimate
     *
     */
     
    public int getUnavailableSeconds() {
	return permanent ? -1 : seconds;
    }

    /**
     * Prints the stack trace of this exception to the standard error stream.
     */
    public void printStackTrace()
    {
        this.printStackTrace(System.err);
    }

    /**
     * Prints the stack trace of this exception to the specified print stream.
     *
     * @param out the <code>PrintStream</code> to use for output
     */
    public void printStackTrace(java.io.PrintStream out) 
    {
        this.printStackTrace(new java.io.PrintWriter(out, true));
    }

    /**
     * Prints the stack trace of this exception to the specified print writer.
     * 
     * @param out the <code>PrintWriter</code> to use for output.
     */
    public void printStackTrace(java.io.PrintWriter out)
    {
        super.printStackTrace(out);

        if( getRootCause () != null )
        {
            out.println();
            out.print("Nested Exception is ");
            getRootCause ().printStackTrace(out);
        }
    }

}
