package org.apache.jetspeed.portlet.event;

import org.apache.jetspeed.portlet.PortletException;

/**
 * The <CODE>WindowListener</CODE> interface is an addition to the
 * <CODE>Portlet</CODE> interface. If an object wishes to receive events from a
 * portlet window, this interface has to be implemented additionally to the
 * <CODE>Portlet</CODE> interface.
 * 
 * @author <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 * @see WindowEvent
 */
public interface WindowListener
{
    /**
     ** Notifies this listener that a portlet window has been
     ** detached.
     **
     ** @param   event
     **          the window event
     **
     ** @exception   PortletException
     **              if the listener has trouble fulfilling the
     **              request
     **/

    public void windowDetached (WindowEvent event) throws PortletException;

    /**
     ** Notifies this listener that a portlet window has been
     ** maximized.
     **
     ** @param   event
     **          the window event
     **
     ** @exception   PortletException
     **              if the listener has trouble fulfilling the
     **              request
     **/

    public void windowMaximized (WindowEvent event) throws PortletException;

    /**
     ** Notifies this listener that a portlet window has been
     ** minimized.
     **
     ** @param   event
     **          the window event
     **
     ** @exception   PortletException
     **              if the listener has trouble fulfilling the
     **              request
     **/

    public void windowMinimized (WindowEvent event) throws PortletException;

    /**
     ** Notifies this listener that a portlet window is about
     ** to be closed.
     **
     ** @param   event
     **          the window event
     **
     ** @exception   PortletException
     **              if the listener has trouble fulfilling the
     **              request
     **/

    public void windowClosing (WindowEvent event) throws PortletException;

    /**
     ** Notifies this listener that a portlet window has been
     ** closed.
     **
     ** @param   event
     **          the window event
     **
     ** @exception   PortletException
     **              if the listener has trouble fulfilling the
     **              request
     **/

    public void windowClosed (WindowEvent event) throws PortletException;

    /**
     ** Notifies this listener that a portlet window has been
     ** restored from being minimized or maximized, respectively.
     **
     ** @param   event
     **          the window event
     **
     ** @exception   PortletException
     **              if the listener has trouble fulfilling the
     **              request
     **/

    public void windowRestored (WindowEvent event) throws PortletException;

}