package org.apache.jetspeed.portlet.service.spi;

import org.apache.jetspeed.portlet.service.PortletService;
import org.apache.jetspeed.portlet.service.PortletServiceUnavailableException;

import java.util.Properties;
import javax.servlet.ServletConfig;

/**
 * All interfaces in this Service Provider Interface (SPI) package are needed
 * by all implementations of services.
 *
 * The <code>PortletServiceFactory</code> interface has to be implemented
 * by all portlet service factory implementations.
 *
 * @author <A HREF="mailto:stephan.hesmer@de.ibm.com">Stephan Hesmer</A>
 */
public interface PortletServiceFactory
{
    /**
     * createPortletServiceFactory instanciates the
     * given class and initializes it
     * 
     * @param service the Class of the service
     * @param serviceProperties
     *                the properties from the registry that also
     *                contains the configuration of the PortletServices
     * @param servletConfig
     *                the ServletConfig
     * @return the PortletService
     * @exception PortletServiceUnavailableException
     */
    public PortletService createPortletService(Class service, 
                                               Properties serviceProperties,
                                               ServletConfig servletConfig) 
        throws PortletServiceUnavailableException;

}
