package org.apache.jetspeed.portlet.service.spi;

import org.apache.jetspeed.portlet.service.PortletService;
import org.apache.jetspeed.portlet.service.PortletServiceUnavailableException;

/**
 * All interfaces in this Service Provider Interface (SPI) package are needed
 * by all implementations of services.
 *
 * The <code>PortletServiceProvider</code> interface has to be implemented
 * by all portlet service implementations, so that it can be
 * instantiated and destroyed by the appropriate service factory.
 *
 * @author <A HREF="mailto:stephan.hesmer@de.ibm.com">Stephan Hesmer</A>
 */
public interface PortletServiceProvider extends PortletService
{
    /**
    * Initialized the portlet service. The <tt>init</tt> method is invoked by
    * the portlet container immediately after a portlet service has been 
    * instantiated and before it is passed to the requestor.
    */
    public void init(PortletServiceConfig config) throws PortletServiceUnavailableException;
    
    /**
    * The <tt>destroy</tt> method is invoked by the portlet container 
    * to destroy a portlet service. This method must free all resources
    * allocated to the portlet service.
    */
    public void destroy();

}
