package org.apache.jetspeed.portletcontainer;

// jetspeed stuff
import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.util.*;

import org.apache.jetspeed.portletcontainer.information.*;
import org.apache.jetspeed.portletcontainer.om.clientregistry.*;

// turbine stuff
import org.apache.turbine.util.Log;

// java stuff
import java.util.Vector;
import java.util.Hashtable;
import java.util.Enumeration;
import java.lang.reflect.*;

public class ClientImpl implements Client
{
    private Vector capabilities = null;
    private ClientEntry clientEntry = null;
     
    private static Hashtable allCapabilities = new Hashtable();

    static {
        Field[] fields;

        //Create hashtables with fieldnames
        try
        {
            //For parameter iCapability
            fields = Capability.class.getFields();
            for (int i = 0; i < fields.length; i++)
            {
                String name = fields[i].getName();
                allCapabilities.put(name,fields[i].get(null));
            }
        }
        catch (IllegalAccessException exc)
        {
            System.err.println("ClientImpl: ClientImpl(): Error with Field.get(null): " + exc.toString());
        }
    }

    public ClientImpl(PortalInformationProvider provider)
    {
        try {
            this.clientEntry = provider.findClientEntry();
        }
        catch (java.io.IOException e) {
            Log.error("ClientImpl: Unable to determine client.",e);
        }
        if (this.clientEntry==null) {
            Log.warn("ClientImpl: Unrecognized client - Please update your client configuartion.");
        }
        matchCapabilities();
    }

    public String getManufacturer ()
    {
        if (clientEntry==null) return "";
        else return clientEntry.getManufacturer();
    }

    public String getModel ()
    {
        if (clientEntry==null) return "";
        else return clientEntry.getModel();
    }

    public String getVersion ()
    {
        if (clientEntry==null) return "";
        else return clientEntry.getVersion();
    }

    public String getUserAgent ()
    {
        if (clientEntry==null) return "";
        else return clientEntry.getUserAgent();
    }

    public boolean isCapableOf (Capability capability)
    {
        if (capabilities==null) return false;
        return capabilities.contains(capability);
    }


    public boolean isCapableOf (Capability [] capabilities)
    {
        if (capabilities==null) return false;
        for (int i=0; i<capabilities.length; i++)
            if (!this.capabilities.contains(capabilities[i])) return false;
        return true;
    }

    public String getMimeType ()
    {
        if (clientEntry==null) return "text/html";
        else {
            return clientEntry.getMimeType();
        }
    }

    public String getMarkupName ()
    {
        if (clientEntry==null) return "html";
        else {
            return clientEntry.getMarkupName();
        }
    }

    // additional methods

    private void matchCapabilities()
    {
        capabilities = new Vector();
        Enumeration cap = clientEntry.getCapabilityMap().getCapabilities();
        while (cap.hasMoreElements()) {
            String capability = (String)cap.nextElement();
            capabilities.add(allCapabilities.get(capability));
        }
    }

    public ClientEntry getClientEntry()
    {
        return clientEntry;
    }
}
