package org.apache.jetspeed.portletcontainer.information;

//jetspeed
import org.apache.jetspeed.portlet.*;

import org.apache.jetspeed.portletcontainer.om.applicationregistry.*;
import org.apache.jetspeed.portletcontainer.om.clientregistry.*;
import org.apache.jetspeed.portletcontainer.om.portletinstanceregistry.*;
import org.apache.jetspeed.portletcontainer.om.portletregistry.*;

// java stuff
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;

import com.ibm.wps.ws.rpi.RPIConstants;

import java.io.*;
import java.util.Locale;
import java.util.Enumeration;
import java.util.Hashtable;

/**
 * <P>
 * The <CODE>UserInformationAccess</CODE> static accessor class to
 * get information about the user.
 * </P>
 *
 * @author <a href="shesmer@raleigh.ibm.com">Stephan Hesmer</a>
 */
public class UserInformationAccess
{

    /**
     * Returns the <CODE>UserInformation</CODE> class with all necessary
     * information about the user. Returns <CODE>NULL</CODE> if no
     * user is currently logged in.
     *
     * @return the user information
     */
    public static UserInformation getUserInformation( HttpSession session )
    {
        if (session!=null) {
        	/* check if there is a web service user */
        	UserInformation info = (UserInformation)session.getAttribute(com.ibm.wps.ws.rpi.RPIConstants.CLIENT_USERINFORMATION);
        	if (info!=null)
        		return info;        		
        	/* normal handling */
            org.apache.turbine.om.security.User user  =
                (org.apache.turbine.om.security.User) session.getAttribute (com.ibm.wps.engine.Constants.INTERNAL_USER);
            if ((user!=null) && (user.hasLoggedIn())) {
                return new com.ibm.wps.portletcontainer.UserInformationImpl( user );
            }
        }
        return null;
    }

}
