/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portletcontainer.om.applicationregistry;

import com.ibm.wps.util.ObjectID;
import java.util.Map;
import java.util.Enumeration;

/**
 * <P>
 * The <CODE>ApplicationEntry</CODE> interface represents exactly
 * one portlet application. It is accessed by the portlet container
 * to get information about a specific portlet application.
 * </P>
 * <P>
 * The interfaces defined in this package represent an abstract object
 * model (OM) that is applicable for different implementations.
 * The abstract OM defines only how the data is stored and accessed
 * in the memory. Each implementation can store the data in different ways.
 * </P>
 * <P>
 * This abstraction layer helps to generalize the portlet container from
 * special implementations like data storage and moreover it is not bound
 * to a special Application Server.
 * </P>
 * 
 * @author <a href="shesmer@raleigh.ibm.com">Stephan Hesmer</a>
 */
public interface ConcreteApplicationEntry
{

    /**
     * Returns the identifier of this portlet application.
     * 
     * @return the identifier of this portlet application
     */
    public ObjectID getAid();

    /**
     * Returns the root portlet application.
     * 
     * @return the root portlet application
     */
    public ApplicationEntry getRootApplication();

    /**
     * Returns the parent portlet application or null if the parent is
     * the root element and no concrete application.
     * 
     * @return the parent portlet application
     */
    public ConcreteApplicationEntry getParentApplication();

    /**
     * Returns all portlets of this application
     * as an enumeration of <CODE>ConcretePortletEntry</CODE> elements.
     * 
     * @return an enumeration of <CODE>ConcretePortletEntry</CODE> elements
     * @throws IOException
     */
    public Enumeration getConcretePortlets();

    /**
     * Returns the name of this portlet application.
     * 
     * @return the name of this portlet application
     */
    public String getName();

    /**
     * Sets the name of this portlet application.
     * 
     * @param name   the new name of this portlet application
     */
    public void setName(String name);

    /**
     * Returns a hashtable containing name[string]/value[string] pairs of all parameters
     * of this portlet.
     * 
     * @return a hashtable containing name[string]/value[string] pairs
     */
    public Map getParameters ();

    /**
     * Sets a hashtable containing name[string]/value[string] pairs of all parameters
     * of this portlet.
     * 
     * @param parameters    a hashtable containing name[string]/value[string] pairs
     */
    public void setParameters (Map parameters);

}
