package org.apache.jetspeed.portletcontainer.om.portletregistry;

import org.apache.jetspeed.portletcontainer.om.applicationregistry.ApplicationEntry;
import org.apache.jetspeed.portletcontainer.om.clientregistry.ClientEntry;
import com.ibm.wps.util.ObjectID;
import java.util.Enumeration;

/**
 * <P>
 * The <CODE>PortletEntry</CODE> interface represents exactly
 * one portlet and is accessed by the portlet container to query 
 * information about each portlet stored in the PortletRegistry.
 * </P>
 * <P>
 * This abstraction layer helps to generalize the portlet container from
 * special implementations like data storage and moreover it is not bound
 * to a special Application Server.
 * </P>
 * 
 * @author <a href="shesmer@raleigh.ibm.com">Stephan Hesmer</a>
 */
public interface PortletEntry
{

    /**
     * Returns the identifier of this portlet.
     * 
     * @return a string containing the portlet identifier
     */
    public ObjectID getPid();

    /**
     * Returns the portlet application that the portlet
     * runs in as a string.
     * 
     * @return the portlet application object
     */
    public ApplicationEntry getApplication ();

    /**
     * Returns the name of this portlet.
     * 
     * @return a string containing the portlet name
     */
    public String getName();

    /**
     * Sets the name of this portlet.
     * 
     * @param name       a string containing the portlet name
     */
    public void setName(String name);

    /**
     * Returns the servlet mapping of this portlet
     * 
     * @return a string containing the servlet mapping
     */
    public String getServletMapping();

    /**
     * Returns an enumeration that defines which portlet modes
     * per client the portlet supports. The enumeration
     * consists of elements of the type <CODE>Portlet.Mode</CODE>.
     * 
     * @param client the client device the user connects to the portal with
     * @return an enumeration of portlet modes
     * @see Portlet.Mode
     */
    public Enumeration getSupportedModes (ClientEntry client);

    /**
     * Sets an enumeration that defines which portlet modes
     * per client the portlet supports. The enumeration
     * consists of elements of the type <CODE>Portlet.Mode</CODE>.
     * 
     * @param client    the client device the user connects to the portal with
     * @param modes     an enumeration of portlet modes
     * @see Portlet.Mode
     */
    public void setSupportedModes (ClientEntry client, Enumeration modes);

    /**
     * Returns an enumeration that defines which portlet window states
     * the portlet supports. The enumeration consists of elements 
     * of the type <CODE>PortletWindow.State</CODE>.
     * 
     * @return an enumeration of portlet window states
     * @see PortletWindow.State
     */
    public Enumeration getSupportedStates ();

    /**
     * Sets an enumeration that defines which portlet window states
     * the portlet supports. The enumeration consists of elements 
     * of the type <CODE>PortletWindow.State</CODE>.
     * 
     * @param modes     an enumeration of portlet window states
     * @see PortletWindow.State
     */
    public void setSupportedStates (Enumeration modes);

    /**
     * Indicates that this portlet is shared among users and
     * thus is not user-specific.
     * 
     * @return <code>true</code> if the portlet is shared among users;
     *         <code>false</code> otherwise.
     */
    public boolean isShared();

    /**
     * Indicates when the portlet expires and should be reloaded into the cache
     * 
     * @return the time in seconds when the portlet expires
     */
    public long getExpires();

}
