package org.apache.jetspeed.portlets;

//Jetspeed stuff
import org.apache.jetspeed.portlet.*;

// special
import org.apache.jetspeed.portletcontainer.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

//java stuff
import java.io.*;
import java.util.*;

public class URITestPortlet extends AbstractPortlet {

    public void init (PortletConfig portletConfig) throws UnavailableException
    {
        super.init( portletConfig );
        
    }
    
    
    public void service (PortletRequest request,
                         PortletResponse response) throws PortletException,
                                                          IOException
    {
        PrintWriter writer = response.getWriter();

        PortletURI uri = response.createURI();
        writer.println("<a href='"+uri.toString()+"'>Current Mode - Current State</a><br>");
        uri = response.createURI(PortletWindow.State.NORMAL);
        writer.println("<a href='"+uri.toString()+"'>Current Mode - Normal State</a><br>");
        uri = response.createURI(PortletWindow.State.MAXIMIZED);
        writer.println("<a href='"+uri.toString()+"'>Current Mode - Maximized State</a><br>");
        uri = response.createReturnURI();
        if (uri!=null) {
            writer.println("<a href='"+uri.toString()+"'>Return URL</a><br>");
        }
        else {
            writer.println("No Return URL available<br>");
        }

    }

}
