package org.apache.jetspeed.portlets.util;

//Java classes
import java.io.IOException;
import java.net.*;
import java.io.*;

//XML classes
import org.xml.sax.InputSource;
import org.xml.sax.EntityResolver;

//PortletAPI classes
import org.apache.jetspeed.portlet.service.ContentAccessService;
import org.apache.jetspeed.portlet.PortletRequest;
import org.apache.jetspeed.portlet.PortletResponse;


public class PortletEntityResolver implements EntityResolver
{

	ContentAccessService iService = null;
	PortletRequest iRequest = null;
	PortletResponse iResponse = null;


	public void SetContentService(ContentAccessService aService, PortletRequest aRequest, PortletResponse aResponse)
	{
		if ( aService == null || aResponse == null || aRequest == null )
			throw new IllegalArgumentException("PortletEntityResolver: parameter should not be null");


		iService = aService;
		iRequest = aRequest;
		iResponse = aResponse;
	}

	public InputSource resolveEntity(String publicID, String systemID)
	{

		try
		{
			URL url = iService.getURL(systemID,iRequest,iResponse);

			URLConnection conn = url.openConnection();       

			InputStream is = conn.getInputStream();

			
			
			
			String content = "";
            int rc = 0;
			byte [] buffer = new byte[4096];
			while ( rc >= 0 )
			{
				if ( rc>0 )
					content = content + new String(buffer,0,rc);
				rc = is.read(buffer);
			}

			content = "";
			Reader r = new StringReader(content);

			InputSource in = new InputSource (r);

			return in;


		}
		catch ( Exception e )
		{

		}
		finally
		{
			return null;
		}


	}
}
