/*
* Licensed to the Apache Software Foundation (ASF) under one or more
* contributor license agreements.  See the NOTICE file distributed with
* this work for additional information regarding copyright ownership.
* The ASF licenses this file to You under the Apache License, Version 2.0
* (the "License"); you may not use this file except in compliance with
* the License.  You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.apache.jetspeed.security.activeauthentication;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * <p>
 * IdentityTokenImpl
 * </p>
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: $
 *
 */
public class IdentityTokenImpl implements IdentityToken, Serializable
{
    private Map attributes = new HashMap();
    private String token;
    
    public IdentityTokenImpl(String uniqueToken)
    {
        this.token = uniqueToken;        
    }
    
    public Object getAttribute(String name)
    {
        return attributes.get(name);
    }

    public Iterator getAttributeNames()
    {
        return attributes.keySet().iterator();
    }

    public String getToken()
    {
        return token;
    }

    public void setAttribute(String name, Object value)
    {
        if (value instanceof Serializable)
            attributes.put(name, value);
    }
}