/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DereferenceExpression
extends Expression {
    private final Expression base;
    private final Optional<Identifier> field;

    public DereferenceExpression(Expression base, Identifier field) {
        this(Optional.empty(), base, Optional.of(field));
    }

    public DereferenceExpression(NodeLocation location, Expression base, Identifier field) {
        this(Optional.of(location), base, Optional.of(field));
    }

    public DereferenceExpression(Identifier label) {
        this(Optional.empty(), (Expression)label, Optional.empty());
    }

    public DereferenceExpression(NodeLocation location, Identifier label) {
        this(Optional.of(location), (Expression)label, Optional.empty());
    }

    private DereferenceExpression(Optional<NodeLocation> location, Expression base, Optional<Identifier> field) {
        super(location);
        Preconditions.checkArgument((base != null ? 1 : 0) != 0, (Object)"base is null");
        Objects.requireNonNull(field, "field is null");
        this.base = base;
        this.field = field;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDereferenceExpression(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder children = ImmutableList.builder();
        children.add((Object)this.base);
        this.field.ifPresent(arg_0 -> ((ImmutableList.Builder)children).add(arg_0));
        return children.build();
    }

    public Expression getBase() {
        return this.base;
    }

    public Optional<Identifier> getField() {
        return this.field;
    }

    public static QualifiedName getQualifiedName(DereferenceExpression expression) {
        QualifiedName baseQualifiedName;
        if (!expression.field.isPresent()) {
            return null;
        }
        Identifier field = expression.field.get();
        ImmutableList parts = null;
        if (expression.base instanceof Identifier) {
            parts = ImmutableList.of((Object)((Identifier)expression.base), (Object)field);
        } else if (expression.base instanceof DereferenceExpression && (baseQualifiedName = DereferenceExpression.getQualifiedName((DereferenceExpression)expression.base)) != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(baseQualifiedName.getOriginalParts());
            builder.add((Object)field);
            parts = builder.build();
        }
        return parts == null ? null : QualifiedName.of((Iterable<Identifier>)parts);
    }

    public static Expression from(QualifiedName name) {
        Expression result = null;
        for (String part : name.getParts()) {
            if (result == null) {
                result = new Identifier(part);
                continue;
            }
            result = new DereferenceExpression(result, new Identifier(part));
        }
        return result;
    }

    public static boolean isQualifiedAllFieldsReference(Expression expression) {
        return expression instanceof DereferenceExpression && !((DereferenceExpression)expression).field.isPresent();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DereferenceExpression that = (DereferenceExpression)o;
        return Objects.equals(this.base, that.base) && Objects.equals(this.field, that.field);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base, this.field);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return DereferenceExpression.sameClass(this, other);
    }
}

