/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.kubernetes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ContainerPort;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1EnvVar;
import io.kubernetes.client.openapi.models.V1EnvVarSource;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1ObjectFieldSelector;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.openapi.models.V1PodSpec;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServicePort;
import io.kubernetes.client.openapi.models.V1ServiceSpec;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import io.kubernetes.client.openapi.models.V1StatefulSetSpec;
import io.kubernetes.client.openapi.models.V1Toleration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import okhttp3.Response;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.functions.auth.FunctionAuthUtils;
import org.apache.pulsar.functions.auth.KubernetesFunctionAuthProvider;
import org.apache.pulsar.functions.instance.AuthenticationConfig;
import org.apache.pulsar.functions.instance.InstanceConfig;
import org.apache.pulsar.functions.instance.InstanceUtils;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.apache.pulsar.functions.proto.InstanceControlGrpc;
import org.apache.pulsar.functions.runtime.Runtime;
import org.apache.pulsar.functions.runtime.RuntimeUtils;
import org.apache.pulsar.functions.runtime.kubernetes.KubernetesManifestCustomizer;
import org.apache.pulsar.functions.runtime.kubernetes.KubernetesRuntimeFactory;
import org.apache.pulsar.functions.secretsproviderconfigurator.SecretsProviderConfigurator;
import org.apache.pulsar.functions.utils.Actions;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class KubernetesRuntime
implements Runtime {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KubernetesRuntime.class);
    private static final String ENV_SHARD_ID = "SHARD_ID";
    private static final int maxJobNameSize = 53;
    private static final int maxLabelSize = 63;
    public static final Pattern VALID_POD_NAME_REGEX = Pattern.compile("[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*", 2);
    private static final String PULSARFUNCTIONS_CONTAINER_NAME = "pulsarfunction";
    private final AppsV1Api appsClient;
    private final CoreV1Api coreClient;
    static final List<String> TOLERATIONS = Collections.unmodifiableList(Arrays.asList("node.kubernetes.io/not-ready", "node.alpha.kubernetes.io/notReady", "node.alpha.kubernetes.io/unreachable"));
    private static final long GRPC_TIMEOUT_SECS = 5L;
    private final boolean authenticationEnabled;
    private List<String> processArgs;
    private ManagedChannel[] channel;
    private InstanceControlGrpc.InstanceControlFutureStub[] stub;
    private InstanceConfig instanceConfig;
    private final String jobNamespace;
    private final String jobName;
    private final Map<String, String> customLabels;
    private final Map<String, String> functionDockerImages;
    private final String pulsarDockerImageName;
    private final String imagePullPolicy;
    private final String pulsarRootDir;
    private final String configAdminCLI;
    private final String userCodePkgUrl;
    private final String originalCodeFileName;
    private final String originalTransformFunctionFileName;
    private final String pulsarAdminUrl;
    private final SecretsProviderConfigurator secretsProviderConfigurator;
    private int percentMemoryPadding;
    private double cpuOverCommitRatio;
    private double memoryOverCommitRatio;
    private int gracePeriodSeconds;
    private final Optional<KubernetesFunctionAuthProvider> functionAuthDataCacheProvider;
    private final AuthenticationConfig authConfig;
    private Integer grpcPort;
    private Integer metricsPort;
    private String narExtractionDirectory;
    private final Optional<KubernetesManifestCustomizer> manifestCustomizer;
    private String functionInstanceClassPath;
    private String downloadDirectory;

    KubernetesRuntime(AppsV1Api appsClient, CoreV1Api coreClient, String jobNamespace, String jobName, Map<String, String> customLabels, Boolean installUserCodeDependencies, String pythonDependencyRepository, String pythonExtraDependencyRepository, String pulsarDockerImageName, Map<String, String> functionDockerImages, String imagePullPolicy, String pulsarRootDir, InstanceConfig instanceConfig, String instanceFile, String extraDependenciesDir, String logDirectory, String configAdminCLI, String userCodePkgUrl, String originalCodeFileName, String originalTransformFunctionFileName, String pulsarServiceUrl, String pulsarAdminUrl, String stateStorageServiceUrl, AuthenticationConfig authConfig, SecretsProviderConfigurator secretsProviderConfigurator, Integer expectedMetricsCollectionInterval, int percentMemoryPadding, double cpuOverCommitRatio, double memoryOverCommitRatio, int gracePeriodSeconds, Optional<KubernetesFunctionAuthProvider> functionAuthDataCacheProvider, boolean authenticationEnabled, Integer grpcPort, String narExtractionDirectory, Optional<KubernetesManifestCustomizer> manifestCustomizer, String functionInstanceClassPath, String downloadDirectory) throws Exception {
        this.appsClient = appsClient;
        this.coreClient = coreClient;
        this.instanceConfig = instanceConfig;
        this.jobNamespace = jobNamespace;
        this.jobName = jobName;
        this.customLabels = customLabels;
        this.functionDockerImages = functionDockerImages;
        this.pulsarDockerImageName = pulsarDockerImageName;
        this.imagePullPolicy = imagePullPolicy;
        this.pulsarRootDir = pulsarRootDir;
        this.configAdminCLI = configAdminCLI;
        this.userCodePkgUrl = userCodePkgUrl;
        this.downloadDirectory = StringUtils.isNotEmpty((CharSequence)downloadDirectory) ? downloadDirectory : this.pulsarRootDir;
        this.originalCodeFileName = this.downloadDirectory + "/" + originalCodeFileName;
        this.originalTransformFunctionFileName = StringUtils.isNotEmpty((CharSequence)originalTransformFunctionFileName) ? this.downloadDirectory + "/" + originalTransformFunctionFileName : originalTransformFunctionFileName;
        this.pulsarAdminUrl = pulsarAdminUrl;
        this.secretsProviderConfigurator = secretsProviderConfigurator;
        this.percentMemoryPadding = percentMemoryPadding;
        this.cpuOverCommitRatio = cpuOverCommitRatio;
        this.memoryOverCommitRatio = memoryOverCommitRatio;
        this.gracePeriodSeconds = gracePeriodSeconds;
        this.authenticationEnabled = authenticationEnabled;
        this.manifestCustomizer = manifestCustomizer;
        this.functionInstanceClassPath = functionInstanceClassPath;
        Object logConfigFile = null;
        String secretsProviderClassName = secretsProviderConfigurator.getSecretsProviderClassName(instanceConfig.getFunctionDetails());
        String secretsProviderConfig = null;
        if (secretsProviderConfigurator.getSecretsProviderConfig(instanceConfig.getFunctionDetails()) != null) {
            secretsProviderConfig = new Gson().toJson((Object)secretsProviderConfigurator.getSecretsProviderConfig(instanceConfig.getFunctionDetails()));
        }
        switch (instanceConfig.getFunctionDetails().getRuntime()) {
            case JAVA: {
                logConfigFile = "kubernetes_instance_log4j2.xml";
                break;
            }
            case PYTHON: {
                logConfigFile = pulsarRootDir + "/conf/functions-logging/console_logging_config.ini";
                break;
            }
        }
        this.authConfig = authConfig;
        this.functionAuthDataCacheProvider = functionAuthDataCacheProvider;
        this.grpcPort = grpcPort;
        this.metricsPort = instanceConfig.hasValidMetricsPort() ? Integer.valueOf(instanceConfig.getMetricsPort()) : null;
        this.narExtractionDirectory = narExtractionDirectory;
        this.processArgs = new LinkedList<String>();
        this.processArgs.addAll(RuntimeUtils.getArgsBeforeCmd(instanceConfig, extraDependenciesDir));
        if (instanceConfig.getFunctionDetails().getRuntime() == Function.FunctionDetails.Runtime.GO) {
            this.processArgs.add("chmod");
            this.processArgs.add("777");
            this.processArgs.add(this.originalCodeFileName);
            this.processArgs.add("&&");
        }
        this.processArgs.add("exec");
        this.processArgs.addAll(RuntimeUtils.getCmd(instanceConfig, instanceFile, extraDependenciesDir, logDirectory, this.originalCodeFileName, this.originalTransformFunctionFileName, pulsarServiceUrl, stateStorageServiceUrl, authConfig, "$SHARD_ID", grpcPort, -1L, (String)logConfigFile, secretsProviderClassName, secretsProviderConfig, installUserCodeDependencies, pythonDependencyRepository, pythonExtraDependencyRepository, narExtractionDirectory, functionInstanceClassPath, true, pulsarAdminUrl));
        KubernetesRuntime.doChecks(instanceConfig.getFunctionDetails(), this.jobName);
    }

    @Override
    public void start() throws Exception {
        try {
            this.submitService();
            this.submitStatefulSet();
        }
        catch (Exception e) {
            log.error("Failed start function {}/{}/{} in Kubernetes", new Object[]{this.instanceConfig.getFunctionDetails().getTenant(), this.instanceConfig.getFunctionDetails().getNamespace(), this.instanceConfig.getFunctionDetails().getName(), e});
            this.stop();
            throw e;
        }
        this.setupGrpcChannelIfNeeded();
    }

    @Override
    public void reinitialize() {
        this.setupGrpcChannelIfNeeded();
    }

    private synchronized void setupGrpcChannelIfNeeded() {
        if (this.channel == null || this.stub == null) {
            this.channel = new ManagedChannel[this.instanceConfig.getFunctionDetails().getParallelism()];
            this.stub = new InstanceControlGrpc.InstanceControlFutureStub[this.instanceConfig.getFunctionDetails().getParallelism()];
            String jobName = KubernetesRuntime.createJobName(this.instanceConfig.getFunctionDetails(), this.jobName);
            for (int i = 0; i < this.instanceConfig.getFunctionDetails().getParallelism(); ++i) {
                String address = KubernetesRuntime.getServiceUrl(jobName, this.jobNamespace, i);
                this.channel[i] = ManagedChannelBuilder.forAddress((String)address, (int)this.grpcPort).usePlaintext().build();
                this.stub[i] = InstanceControlGrpc.newFutureStub((Channel)this.channel[i]);
            }
        }
    }

    @Override
    public void join() throws Exception {
        this.wait();
    }

    @Override
    public void stop() throws Exception {
        if (this.channel != null) {
            for (ManagedChannel cn : this.channel) {
                cn.enterIdle();
            }
        }
        this.deleteStatefulSet();
        this.deleteService();
        if (this.channel != null) {
            for (ManagedChannel cn : this.channel) {
                cn.shutdown();
            }
        }
        this.channel = null;
        this.stub = null;
    }

    @Override
    public Throwable getDeathException() {
        return null;
    }

    @Override
    public CompletableFuture<InstanceCommunication.FunctionStatus> getFunctionStatus(int instanceId) {
        final CompletableFuture<InstanceCommunication.FunctionStatus> retval = new CompletableFuture<InstanceCommunication.FunctionStatus>();
        if (this.stub == null) {
            retval.completeExceptionally(new RuntimeException("Not alive"));
            return retval;
        }
        if (instanceId < 0 || instanceId >= this.stub.length) {
            retval.completeExceptionally(new RuntimeException("Invalid InstanceId"));
            return retval;
        }
        ListenableFuture response = ((InstanceControlGrpc.InstanceControlFutureStub)this.stub[instanceId].withDeadlineAfter(5L, TimeUnit.SECONDS)).getFunctionStatus(Empty.newBuilder().build());
        Futures.addCallback((ListenableFuture)response, (FutureCallback)new FutureCallback<InstanceCommunication.FunctionStatus>(){

            public void onFailure(Throwable throwable) {
                InstanceCommunication.FunctionStatus.Builder builder = InstanceCommunication.FunctionStatus.newBuilder();
                builder.setRunning(false);
                builder.setFailureException(throwable.getMessage());
                retval.complete(builder.build());
            }

            public void onSuccess(InstanceCommunication.FunctionStatus t) {
                retval.complete(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return retval;
    }

    @Override
    public CompletableFuture<InstanceCommunication.MetricsData> getAndResetMetrics() {
        CompletableFuture<InstanceCommunication.MetricsData> retval = new CompletableFuture<InstanceCommunication.MetricsData>();
        retval.completeExceptionally(new RuntimeException("Kubernetes Runtime doesn't support getAndReset metrics via rest"));
        return retval;
    }

    @Override
    public CompletableFuture<Void> resetMetrics() {
        CompletableFuture<Void> retval = new CompletableFuture<Void>();
        retval.completeExceptionally(new RuntimeException("Kubernetes Runtime doesn't support resetting metrics via rest"));
        return retval;
    }

    @Override
    public CompletableFuture<InstanceCommunication.MetricsData> getMetrics(int instanceId) {
        final CompletableFuture<InstanceCommunication.MetricsData> retval = new CompletableFuture<InstanceCommunication.MetricsData>();
        if (this.stub == null) {
            retval.completeExceptionally(new RuntimeException("Not alive"));
            return retval;
        }
        if (instanceId < 0 || instanceId >= this.stub.length) {
            retval.completeExceptionally(new RuntimeException("Invalid InstanceId"));
            return retval;
        }
        ListenableFuture response = ((InstanceControlGrpc.InstanceControlFutureStub)this.stub[instanceId].withDeadlineAfter(5L, TimeUnit.SECONDS)).getMetrics(Empty.newBuilder().build());
        Futures.addCallback((ListenableFuture)response, (FutureCallback)new FutureCallback<InstanceCommunication.MetricsData>(){

            public void onFailure(Throwable throwable) {
                InstanceCommunication.MetricsData.Builder builder = InstanceCommunication.MetricsData.newBuilder();
                retval.complete(builder.build());
            }

            public void onSuccess(InstanceCommunication.MetricsData t) {
                retval.complete(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return retval;
    }

    @Override
    public String getPrometheusMetrics() throws IOException {
        if (this.metricsPort != null) {
            return RuntimeUtils.getPrometheusMetrics(this.metricsPort);
        }
        return null;
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    private void submitService() throws Exception {
        V1Service service = this.createService();
        log.info("Submitting the following service to k8 {}", (Object)this.coreClient.getApiClient().getJSON().serialize((Object)service));
        String fqfn = FunctionCommon.getFullyQualifiedName((Function.FunctionDetails)this.instanceConfig.getFunctionDetails());
        Actions.Action createService = Actions.Action.builder().actionName(String.format("Submitting service for function %s", fqfn)).numRetries(KubernetesRuntimeFactory.numRetries).sleepBetweenInvocationsMs(KubernetesRuntimeFactory.sleepBetweenRetriesMs).supplier(() -> {
            try {
                V1Service response = this.coreClient.createNamespacedService(this.jobNamespace, service, null, null, null, null);
            }
            catch (ApiException e) {
                if (e.getCode() == 409) {
                    log.warn("Service already present for function {}", (Object)fqfn);
                    return Actions.ActionResult.builder().success(true).build();
                }
                String errorMsg = e.getResponseBody() != null ? e.getResponseBody() : e.getMessage();
                return Actions.ActionResult.builder().success(false).errorMsg(errorMsg).build();
            }
            return Actions.ActionResult.builder().success(true).build();
        }).build();
        AtomicBoolean success = new AtomicBoolean(false);
        Actions.newBuilder().addAction(createService.toBuilder().onSuccess(ignored -> success.set(true)).build()).run();
        if (!success.get()) {
            throw new RuntimeException(String.format("Failed to create service for function %s", fqfn));
        }
    }

    @VisibleForTesting
    V1Service createService() {
        String jobName = KubernetesRuntime.createJobName(this.instanceConfig.getFunctionDetails(), this.jobName);
        V1Service service = new V1Service();
        V1ObjectMeta objectMeta = new V1ObjectMeta();
        objectMeta.name(jobName);
        objectMeta.setLabels(this.getLabels(this.instanceConfig.getFunctionDetails()));
        objectMeta.setNamespace(this.jobNamespace);
        service.metadata(objectMeta);
        V1ServiceSpec serviceSpec = new V1ServiceSpec();
        serviceSpec.clusterIP("None");
        V1ServicePort servicePort = new V1ServicePort();
        servicePort.name("grpc").port(this.grpcPort).protocol("TCP");
        serviceSpec.addPortsItem(servicePort);
        serviceSpec.selector(this.getLabels(this.instanceConfig.getFunctionDetails()));
        service.spec(serviceSpec);
        V1Service overridden = this.manifestCustomizer.map(customizer -> customizer.customizeService(this.instanceConfig.getFunctionDetails(), service)).orElse(service);
        overridden.getMetadata().name(jobName);
        return overridden;
    }

    private void submitStatefulSet() throws Exception {
        V1StatefulSet statefulSet = this.createStatefulSet();
        if (this.authenticationEnabled) {
            this.functionAuthDataCacheProvider.ifPresent(kubernetesFunctionAuthProvider -> kubernetesFunctionAuthProvider.configureAuthDataStatefulSet(statefulSet, Optional.ofNullable(FunctionAuthUtils.getFunctionAuthData(Optional.ofNullable(this.instanceConfig.getFunctionAuthenticationSpec())))));
        }
        log.info("Submitting the following spec to k8 {}", (Object)this.appsClient.getApiClient().getJSON().serialize((Object)statefulSet));
        String fqfn = FunctionCommon.getFullyQualifiedName((Function.FunctionDetails)this.instanceConfig.getFunctionDetails());
        Actions.Action createStatefulSet = Actions.Action.builder().actionName(String.format("Submitting statefulset for function %s", fqfn)).numRetries(KubernetesRuntimeFactory.numRetries).sleepBetweenInvocationsMs(KubernetesRuntimeFactory.sleepBetweenRetriesMs).supplier(() -> {
            try {
                V1StatefulSet response = this.appsClient.createNamespacedStatefulSet(this.jobNamespace, statefulSet, null, null, null, null);
            }
            catch (ApiException e) {
                if (e.getCode() == 409) {
                    log.warn("Statefulset already present for function {}", (Object)fqfn);
                    return Actions.ActionResult.builder().success(true).build();
                }
                String errorMsg = e.getResponseBody() != null ? e.getResponseBody() : e.getMessage();
                return Actions.ActionResult.builder().success(false).errorMsg(errorMsg).build();
            }
            return Actions.ActionResult.builder().success(true).build();
        }).build();
        AtomicBoolean success = new AtomicBoolean(false);
        Actions.newBuilder().addAction(createStatefulSet.toBuilder().onSuccess(ignored -> success.set(true)).build()).run();
        if (!success.get()) {
            throw new RuntimeException(String.format("Failed to create statefulset for function %s", fqfn));
        }
    }

    public void deleteStatefulSet() throws InterruptedException {
        String statefulSetName = KubernetesRuntime.createJobName(this.instanceConfig.getFunctionDetails(), this.jobName);
        V1DeleteOptions options = new V1DeleteOptions();
        options.setGracePeriodSeconds(Long.valueOf(this.gracePeriodSeconds));
        options.setPropagationPolicy("Foreground");
        String fqfn = FunctionCommon.getFullyQualifiedName((Function.FunctionDetails)this.instanceConfig.getFunctionDetails());
        Actions.Action deleteStatefulSet = Actions.Action.builder().actionName(String.format("Deleting statefulset for function %s", fqfn)).numRetries(KubernetesRuntimeFactory.numRetries).sleepBetweenInvocationsMs(KubernetesRuntimeFactory.sleepBetweenRetriesMs).supplier(() -> {
            Response response;
            try {
                response = this.appsClient.deleteNamespacedStatefulSetCall(statefulSetName, this.jobNamespace, null, null, Integer.valueOf(this.gracePeriodSeconds), null, "Foreground", options, null).execute();
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    log.warn("Statefulset for function {} does not exist", (Object)fqfn);
                    return Actions.ActionResult.builder().success(true).build();
                }
                String errorMsg = e.getResponseBody() != null ? e.getResponseBody() : e.getMessage();
                return Actions.ActionResult.builder().success(false).errorMsg(errorMsg).build();
            }
            catch (IOException e) {
                return Actions.ActionResult.builder().success(false).errorMsg(e.getMessage()).build();
            }
            if (response.code() == 404) {
                log.warn("Statefulset for function {} does not exist", (Object)fqfn);
                return Actions.ActionResult.builder().success(true).build();
            }
            return Actions.ActionResult.builder().success(response.isSuccessful()).errorMsg(response.message()).build();
        }).build();
        Actions.Action waitForStatefulSetDeletion = Actions.Action.builder().actionName(String.format("Waiting for StatefulSet deletion to complete deletion of function %s", fqfn)).numRetries(KubernetesRuntimeFactory.numRetries * 2).sleepBetweenInvocationsMs(KubernetesRuntimeFactory.sleepBetweenRetriesMs * 2L).supplier(() -> {
            V1StatefulSet response;
            try {
                response = this.appsClient.readNamespacedStatefulSet(statefulSetName, this.jobNamespace, null);
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return Actions.ActionResult.builder().success(true).build();
                }
                String errorMsg = e.getResponseBody() != null ? e.getResponseBody() : e.getMessage();
                return Actions.ActionResult.builder().success(false).errorMsg(errorMsg).build();
            }
            return Actions.ActionResult.builder().success(false).errorMsg(response.getStatus().toString()).build();
        }).build();
        Actions.Action waitForStatefulPodsToTerminate = Actions.Action.builder().actionName(String.format("Waiting for pods for function %s to terminate", fqfn)).numRetries(KubernetesRuntimeFactory.numRetries * 2).sleepBetweenInvocationsMs(KubernetesRuntimeFactory.sleepBetweenRetriesMs * 2L).supplier(() -> {
            V1PodList response;
            Map<String, String> validLabels = this.getLabels(this.instanceConfig.getFunctionDetails());
            String labels = String.format("tenant=%s,namespace=%s,name=%s", validLabels.get("tenant"), validLabels.get("namespace"), validLabels.get("name"));
            try {
                response = this.coreClient.listNamespacedPod(this.jobNamespace, null, null, null, null, labels, null, null, null, null, null);
            }
            catch (ApiException e) {
                String errorMsg = e.getResponseBody() != null ? e.getResponseBody() : e.getMessage();
                return Actions.ActionResult.builder().success(false).errorMsg(errorMsg).build();
            }
            if (response.getItems().size() > 0) {
                return Actions.ActionResult.builder().success(false).errorMsg(response.getItems().size() + " pods still alive.").build();
            }
            return Actions.ActionResult.builder().success(true).build();
        }).build();
        AtomicBoolean success = new AtomicBoolean(false);
        Actions.newBuilder().addAction(deleteStatefulSet.toBuilder().continueOn(Boolean.valueOf(true)).build()).addAction(waitForStatefulSetDeletion.toBuilder().continueOn(Boolean.valueOf(false)).onSuccess(ignored -> success.set(true)).build()).addAction(deleteStatefulSet.toBuilder().continueOn(Boolean.valueOf(true)).build()).addAction(waitForStatefulSetDeletion.toBuilder().onSuccess(ignored -> success.set(true)).build()).run();
        if (!success.get()) {
            throw new RuntimeException(String.format("Failed to delete statefulset for function %s", fqfn));
        }
        Actions.newBuilder().addAction(waitForStatefulPodsToTerminate).run();
    }

    public void deleteService() throws InterruptedException {
        V1DeleteOptions options = new V1DeleteOptions();
        options.setGracePeriodSeconds(Long.valueOf(0L));
        options.setPropagationPolicy("Foreground");
        String fqfn = FunctionCommon.getFullyQualifiedName((Function.FunctionDetails)this.instanceConfig.getFunctionDetails());
        String serviceName = KubernetesRuntime.createJobName(this.instanceConfig.getFunctionDetails(), this.jobName);
        Actions.Action deleteService = Actions.Action.builder().actionName(String.format("Deleting service for function %s", fqfn)).numRetries(KubernetesRuntimeFactory.numRetries).sleepBetweenInvocationsMs(KubernetesRuntimeFactory.sleepBetweenRetriesMs).supplier(() -> {
            Response response;
            try {
                response = this.coreClient.deleteNamespacedServiceCall(serviceName, this.jobNamespace, null, null, Integer.valueOf(0), null, "Foreground", options, null).execute();
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    log.warn("Service for function {} does not exist", (Object)fqfn);
                    return Actions.ActionResult.builder().success(true).build();
                }
                String errorMsg = e.getResponseBody() != null ? e.getResponseBody() : e.getMessage();
                return Actions.ActionResult.builder().success(false).errorMsg(errorMsg).build();
            }
            catch (IOException e) {
                return Actions.ActionResult.builder().success(false).errorMsg(e.getMessage()).build();
            }
            if (response.code() == 404) {
                log.warn("Service for function {} does not exist", (Object)fqfn);
                return Actions.ActionResult.builder().success(true).build();
            }
            return Actions.ActionResult.builder().success(response.isSuccessful()).errorMsg(response.message()).build();
        }).build();
        Actions.Action waitForServiceDeletion = Actions.Action.builder().actionName(String.format("Waiting for service deletion to complete deletion of function %s", fqfn)).numRetries(KubernetesRuntimeFactory.numRetries).sleepBetweenInvocationsMs(KubernetesRuntimeFactory.sleepBetweenRetriesMs).supplier(() -> {
            V1Service response;
            try {
                response = this.coreClient.readNamespacedService(serviceName, this.jobNamespace, null);
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return Actions.ActionResult.builder().success(true).build();
                }
                String errorMsg = e.getResponseBody() != null ? e.getResponseBody() : e.getMessage();
                return Actions.ActionResult.builder().success(false).errorMsg(errorMsg).build();
            }
            return Actions.ActionResult.builder().success(false).errorMsg(response.getStatus().toString()).build();
        }).build();
        AtomicBoolean success = new AtomicBoolean(false);
        Actions.newBuilder().addAction(deleteService.toBuilder().continueOn(Boolean.valueOf(true)).build()).addAction(waitForServiceDeletion.toBuilder().continueOn(Boolean.valueOf(false)).onSuccess(ignored -> success.set(true)).build()).addAction(deleteService.toBuilder().continueOn(Boolean.valueOf(true)).build()).addAction(waitForServiceDeletion.toBuilder().onSuccess(ignored -> success.set(true)).build()).run();
        if (!success.get()) {
            throw new RuntimeException(String.format("Failed to delete service for function %s", fqfn));
        }
    }

    protected List<String> getExecutorCommand() {
        ArrayList<String> cmds = new ArrayList<String>(this.getDownloadCommand(this.instanceConfig.getFunctionDetails(), this.originalCodeFileName, false));
        if (StringUtils.isNotEmpty((CharSequence)this.originalTransformFunctionFileName)) {
            cmds.add("&&");
            cmds.addAll(this.getDownloadCommand(this.instanceConfig.getFunctionDetails(), this.originalTransformFunctionFileName, true));
        }
        cmds.add("&&");
        cmds.add(KubernetesRuntime.setShardIdEnvironmentVariableCommand());
        cmds.add("&&");
        cmds.addAll(this.processArgs);
        return Arrays.asList("sh", "-c", String.join((CharSequence)" ", cmds));
    }

    private List<String> getDownloadCommand(Function.FunctionDetails functionDetails, String userCodeFilePath, boolean transformFunction) {
        return this.getDownloadCommand(functionDetails.getTenant(), functionDetails.getNamespace(), functionDetails.getName(), userCodeFilePath, transformFunction);
    }

    private List<String> getDownloadCommand(String tenant, String namespace, String name, String userCodeFilePath, boolean transformFunction) {
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(this.pulsarRootDir + this.configAdminCLI, "--admin-url", this.pulsarAdminUrl));
        if (this.authenticationEnabled && this.authConfig != null) {
            if (StringUtils.isNotBlank((CharSequence)this.authConfig.getClientAuthenticationPlugin()) && StringUtils.isNotBlank((CharSequence)this.authConfig.getClientAuthenticationParameters())) {
                cmd.addAll(Arrays.asList("--auth-plugin", this.authConfig.getClientAuthenticationPlugin(), "--auth-params", this.authConfig.getClientAuthenticationParameters()));
            }
            if (this.authConfig.isTlsAllowInsecureConnection()) {
                cmd.add("--tls-allow-insecure");
            }
            if (this.authConfig.isTlsHostnameVerificationEnable()) {
                cmd.add("--tls-enable-hostname-verification");
            }
            if (StringUtils.isNotBlank((CharSequence)this.authConfig.getTlsTrustCertsFilePath())) {
                cmd.addAll(Arrays.asList("--tls-trust-cert-path", this.authConfig.getTlsTrustCertsFilePath()));
            }
        }
        cmd.addAll(Arrays.asList("functions", "download", "--tenant", tenant, "--namespace", namespace, "--name", name, "--destination-file", userCodeFilePath));
        if (transformFunction) {
            cmd.add("--transform-function");
        }
        return cmd;
    }

    private static String setShardIdEnvironmentVariableCommand() {
        return String.format("%s=${POD_NAME##*-} && echo shardId=${%s}", ENV_SHARD_ID, ENV_SHARD_ID);
    }

    @VisibleForTesting
    V1StatefulSet createStatefulSet() {
        String jobName = KubernetesRuntime.createJobName(this.instanceConfig.getFunctionDetails(), this.jobName);
        V1StatefulSet statefulSet = new V1StatefulSet();
        V1ObjectMeta objectMeta = new V1ObjectMeta();
        objectMeta.name(jobName);
        objectMeta.setLabels(this.getLabels(this.instanceConfig.getFunctionDetails()));
        objectMeta.setNamespace(this.jobNamespace);
        statefulSet.metadata(objectMeta);
        V1StatefulSetSpec statefulSetSpec = new V1StatefulSetSpec();
        statefulSetSpec.serviceName(jobName);
        statefulSetSpec.setReplicas(Integer.valueOf(this.instanceConfig.getFunctionDetails().getParallelism()));
        statefulSetSpec.setPodManagementPolicy("Parallel");
        V1LabelSelector selector = new V1LabelSelector();
        selector.matchLabels(this.getLabels(this.instanceConfig.getFunctionDetails()));
        statefulSetSpec.selector(selector);
        V1PodTemplateSpec podTemplateSpec = new V1PodTemplateSpec();
        V1ObjectMeta templateMetaData = new V1ObjectMeta().labels(this.getLabels(this.instanceConfig.getFunctionDetails()));
        templateMetaData.annotations(this.getPrometheusAnnotations());
        podTemplateSpec.setMetadata(templateMetaData);
        List<String> command = this.getExecutorCommand();
        podTemplateSpec.spec(this.getPodSpec(command, this.instanceConfig.getFunctionDetails().hasResources() ? this.instanceConfig.getFunctionDetails().getResources() : null));
        statefulSetSpec.setTemplate(podTemplateSpec);
        statefulSet.spec(statefulSetSpec);
        V1StatefulSet overridden = this.manifestCustomizer.map(customizer -> customizer.customizeStatefulSet(this.instanceConfig.getFunctionDetails(), statefulSet)).orElse(statefulSet);
        overridden.getMetadata().name(jobName);
        return statefulSet;
    }

    private Map<String, String> getPrometheusAnnotations() {
        if (this.metricsPort != null) {
            HashMap<String, String> annotations = new HashMap<String, String>();
            annotations.put("prometheus.io/scrape", "true");
            annotations.put("prometheus.io/port", String.valueOf(this.metricsPort));
            return annotations;
        }
        return Collections.emptyMap();
    }

    private Map<String, String> getLabels(Function.FunctionDetails functionDetails) {
        HashMap<String, String> labels = new HashMap<String, String>();
        Function.FunctionDetails.ComponentType componentType = InstanceUtils.calculateSubjectType((Function.FunctionDetails)functionDetails);
        labels.put("component", switch (componentType) {
            case Function.FunctionDetails.ComponentType.FUNCTION -> "function";
            case Function.FunctionDetails.ComponentType.SOURCE -> "source";
            case Function.FunctionDetails.ComponentType.SINK -> "sink";
            default -> "function";
        });
        labels.put("namespace", KubernetesRuntime.toValidLabelName(functionDetails.getNamespace()));
        labels.put("tenant", KubernetesRuntime.toValidLabelName(functionDetails.getTenant()));
        labels.put("name", KubernetesRuntime.toValidLabelName(functionDetails.getName()));
        if (this.customLabels != null && !this.customLabels.isEmpty()) {
            this.customLabels.replaceAll((k, v) -> KubernetesRuntime.toValidLabelName(v));
            labels.putAll(this.customLabels);
        }
        return labels;
    }

    private V1PodSpec getPodSpec(List<String> instanceCommand, Function.Resources resource) {
        V1PodSpec podSpec = new V1PodSpec();
        podSpec.setTerminationGracePeriodSeconds(Long.valueOf(0L));
        podSpec.setTolerations(this.getTolerations());
        LinkedList<V1Container> containers = new LinkedList<V1Container>();
        containers.add(this.getFunctionContainer(instanceCommand, resource));
        podSpec.containers(containers);
        this.secretsProviderConfigurator.configureKubernetesRuntimeSecretsProvider(podSpec, PULSARFUNCTIONS_CONTAINER_NAME, this.instanceConfig.getFunctionDetails());
        return podSpec;
    }

    private List<V1Toleration> getTolerations() {
        ArrayList<V1Toleration> tolerations = new ArrayList<V1Toleration>();
        TOLERATIONS.forEach(t -> {
            V1Toleration toleration = new V1Toleration().key(t).operator("Exists").effect("NoExecute").tolerationSeconds(Long.valueOf(10L));
            tolerations.add(toleration);
        });
        return tolerations;
    }

    @VisibleForTesting
    V1Container getFunctionContainer(List<String> instanceCommand, Function.Resources resource) {
        V1Container container = new V1Container().name(PULSARFUNCTIONS_CONTAINER_NAME);
        Function.FunctionDetails.Runtime runtime = this.instanceConfig.getFunctionDetails().getRuntime();
        String imageName = null;
        if (this.functionDockerImages != null) {
            switch (runtime) {
                case JAVA: {
                    if (this.functionDockerImages.get("JAVA") == null) break;
                    imageName = this.functionDockerImages.get("JAVA");
                    break;
                }
                case PYTHON: {
                    if (this.functionDockerImages.get("PYTHON") == null) break;
                    imageName = this.functionDockerImages.get("PYTHON");
                    break;
                }
                case GO: {
                    if (this.functionDockerImages.get("GO") == null) break;
                    imageName = this.functionDockerImages.get("GO");
                    break;
                }
                default: {
                    imageName = this.pulsarDockerImageName;
                }
            }
            container.setImage(imageName);
        } else {
            container.setImage(this.pulsarDockerImageName);
        }
        container.setImagePullPolicy(this.imagePullPolicy);
        container.setCommand(instanceCommand);
        V1EnvVar envVarPodName = new V1EnvVar();
        envVarPodName.name("POD_NAME").valueFrom(new V1EnvVarSource().fieldRef(new V1ObjectFieldSelector().fieldPath("metadata.name")));
        container.addEnvItem(envVarPodName);
        V1ResourceRequirements resourceRequirements = new V1ResourceRequirements();
        HashMap<String, Quantity> resourceLimit = new HashMap<String, Quantity>();
        HashMap<String, Quantity> resourceRequest = new HashMap<String, Quantity>();
        long ram = resource != null && resource.getRam() != 0L ? resource.getRam() : 0x40000000L;
        long padding = Math.round((double)ram * ((double)this.percentMemoryPadding / 100.0));
        long ramWithPadding = ram + padding;
        long ramRequest = (long)((double)ramWithPadding / this.memoryOverCommitRatio);
        double cpuLimit = resource != null && resource.getCpu() != 0.0 ? resource.getCpu() : 1.0;
        double cpuRequest = cpuLimit / this.cpuOverCommitRatio;
        resourceLimit.put("cpu", Quantity.fromString((String)Double.toString(FunctionCommon.roundDecimal((double)cpuLimit, (int)3))));
        resourceLimit.put("memory", Quantity.fromString((String)Long.toString(ramWithPadding)));
        resourceRequest.put("cpu", Quantity.fromString((String)Double.toString(FunctionCommon.roundDecimal((double)cpuRequest, (int)3))));
        resourceRequest.put("memory", Quantity.fromString((String)Long.toString(ramRequest)));
        resourceRequirements.setRequests(resourceRequest);
        resourceRequirements.setLimits(resourceLimit);
        container.setResources(resourceRequirements);
        container.setPorts(this.getFunctionContainerPorts());
        return container;
    }

    private List<V1ContainerPort> getFunctionContainerPorts() {
        ArrayList<V1ContainerPort> ports = new ArrayList<V1ContainerPort>();
        ports.add(this.getGRPCPort());
        ports.add(this.getPrometheusPort());
        return ports;
    }

    private V1ContainerPort getGRPCPort() {
        V1ContainerPort port = new V1ContainerPort();
        port.setName("grpc");
        port.setContainerPort(this.grpcPort);
        return port;
    }

    private V1ContainerPort getPrometheusPort() {
        V1ContainerPort port = new V1ContainerPort();
        port.setName("prometheus");
        port.setContainerPort(this.metricsPort);
        return port;
    }

    public static String createJobName(Function.FunctionDetails functionDetails, String jobName) {
        return jobName == null ? KubernetesRuntime.createJobName(functionDetails.getTenant(), functionDetails.getNamespace(), functionDetails.getName()) : KubernetesRuntime.createJobName(jobName, functionDetails.getTenant(), functionDetails.getNamespace(), functionDetails.getName());
    }

    private static String toValidPodName(String ori) {
        return ori.toLowerCase().replaceAll("[^a-z0-9-\\.]", "-");
    }

    private static String toValidLabelName(String ori) {
        return StringUtils.left((String)ori.toLowerCase().replaceAll("[^a-zA-Z0-9-_\\.]", "-").replaceAll("^[^a-zA-Z0-9]", "0").replaceAll("[^a-zA-Z0-9]$", "0"), (int)63);
    }

    private static String createJobName(String jobName, String tenant, String namespace, String functionName) {
        String convertedJobName = KubernetesRuntime.toValidPodName(jobName);
        String hashName = String.format("%s-%s-%s-%s", jobName, tenant, namespace, functionName);
        String shortHash = DigestUtils.sha1Hex((String)hashName).toLowerCase().substring(0, 8);
        return convertedJobName + "-" + shortHash;
    }

    private static String createJobName(String tenant, String namespace, String functionName) {
        String convertedJobName;
        String jobNameBase = String.format("%s-%s-%s", tenant, namespace, functionName);
        String jobName = "pf-" + jobNameBase;
        if (jobName.equals(convertedJobName = KubernetesRuntime.toValidPodName(jobName))) {
            return jobName;
        }
        String shortHash = DigestUtils.sha1Hex((String)jobNameBase).toLowerCase().substring(0, 8);
        return convertedJobName + "-" + shortHash;
    }

    private static String getServiceUrl(String jobName, String jobNamespace, int instanceId) {
        return String.format("%s-%d.%s.%s.svc.cluster.local", jobName, instanceId, jobName, jobNamespace);
    }

    public static void doChecks(Function.FunctionDetails functionDetails, String overridenJobName) {
        String jobName = KubernetesRuntime.createJobName(functionDetails, overridenJobName);
        if (!jobName.equals(jobName.toLowerCase())) {
            throw new RuntimeException("Kubernetes does not allow upper case jobNames.");
        }
        Matcher matcher = VALID_POD_NAME_REGEX.matcher(jobName);
        if (!matcher.matches()) {
            throw new RuntimeException("Kubernetes only admits lower case and numbers. (jobName=" + jobName + ")");
        }
        if (jobName.length() > 53) {
            throw new RuntimeException("Kubernetes job name size should be less than 53");
        }
    }

    @Generated
    public List<String> getProcessArgs() {
        return this.processArgs;
    }

    @Generated
    public ManagedChannel[] getChannel() {
        return this.channel;
    }
}

