/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus.metrics;

import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.DoublesUnion;
import com.yahoo.sketches.quantiles.DoublesUnionBuilder;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.bookkeeper.stats.OpStatsData;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.pulsar.broker.stats.prometheus.metrics.ThreadLocalAccessor;

public class DataSketchesOpStatsLogger
implements OpStatsLogger {
    private volatile ThreadLocalAccessor current;
    private volatile ThreadLocalAccessor replacement;
    private volatile DoublesSketch successResult;
    private volatile DoublesSketch failResult;
    private final LongAdder successCountAdder = new LongAdder();
    private final LongAdder failCountAdder = new LongAdder();
    private final LongAdder successSumAdder = new LongAdder();
    private final LongAdder failSumAdder = new LongAdder();

    public DataSketchesOpStatsLogger() {
        this.current = new ThreadLocalAccessor();
        this.replacement = new ThreadLocalAccessor();
    }

    public void registerFailedEvent(long eventLatency, TimeUnit unit) {
        double valueMillis = (double)unit.toMicros(eventLatency) / 1000.0;
        this.failCountAdder.increment();
        this.failSumAdder.add((long)valueMillis);
        this.current.getLocalData().updateFail(valueMillis);
    }

    public void registerSuccessfulEvent(long eventLatency, TimeUnit unit) {
        double valueMillis = (double)unit.toMicros(eventLatency) / 1000.0;
        this.successCountAdder.increment();
        this.successSumAdder.add((long)valueMillis);
        this.current.getLocalData().updateSuccess(valueMillis);
    }

    public void registerSuccessfulValue(long value) {
        this.successCountAdder.increment();
        this.successSumAdder.add(value);
        this.current.getLocalData().updateSuccess(value);
    }

    public void registerFailedValue(long value) {
        this.failCountAdder.increment();
        this.failSumAdder.add(value);
        this.current.getLocalData().updateFail(value);
    }

    public OpStatsData toOpStatsData() {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void rotateLatencyCollection() {
        ThreadLocalAccessor local = this.current;
        this.current = this.replacement;
        this.replacement = local;
        DoublesUnion aggregateSuccess = new DoublesUnionBuilder().build();
        DoublesUnion aggregateFail = new DoublesUnionBuilder().build();
        local.record(aggregateSuccess, aggregateFail);
        this.successResult = aggregateSuccess.getResultAndReset();
        this.failResult = aggregateFail.getResultAndReset();
    }

    public long getCount(boolean success) {
        return success ? this.successCountAdder.sum() : this.failCountAdder.sum();
    }

    public long getSum(boolean success) {
        return success ? this.successSumAdder.sum() : this.failSumAdder.sum();
    }

    public double getQuantileValue(boolean success, double quantile) {
        DoublesSketch s = success ? this.successResult : this.failResult;
        return s != null ? s.getQuantile(quantile) : Double.NaN;
    }
}

