/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.event.client;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.event.client.EventClient;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public abstract class AbstractEventClient
implements EventClient {
    @Override
    @SafeVarargs
    public final <T> ListenableFuture<Void> post(T ... event) throws IllegalArgumentException {
        Objects.requireNonNull(event, "event is null");
        return this.post((Iterable<T>)Arrays.asList(event));
    }

    @Override
    public final <T> ListenableFuture<Void> post(Iterable<T> events) throws IllegalArgumentException {
        Objects.requireNonNull(events, "events is null");
        return this.post((EventClient.EventPoster<T> eventPoster) -> {
            for (Object event : events) {
                Objects.requireNonNull(event, "event is null");
                eventPoster.post(event);
            }
        });
    }

    @Override
    public final <T> ListenableFuture<Void> post(EventClient.EventGenerator<T> eventGenerator) throws IllegalArgumentException {
        try {
            eventGenerator.generate(event -> {
                Objects.requireNonNull(event, "event is null");
                this.postEvent(event);
            });
        }
        catch (IOException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        return Futures.immediateFuture(null);
    }

    protected abstract <T> void postEvent(T var1) throws IOException;
}

