/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.execution.DynamicFiltersCollector;
import io.trino.execution.StateMachine;
import io.trino.execution.TaskFailureListener;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskSource;
import io.trino.execution.TaskState;
import io.trino.execution.TaskStatus;
import io.trino.execution.buffer.BufferResult;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.memory.MemoryPoolAssignmentsRequest;
import io.trino.spi.predicate.Domain;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.plan.DynamicFilterId;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface TaskManager {
    public List<TaskInfo> getAllTaskInfo();

    public TaskInfo getTaskInfo(TaskId var1);

    public TaskStatus getTaskStatus(TaskId var1);

    public ListenableFuture<TaskInfo> getTaskInfo(TaskId var1, long var2);

    public String getTaskInstanceId(TaskId var1);

    public ListenableFuture<TaskStatus> getTaskStatus(TaskId var1, long var2);

    public DynamicFiltersCollector.VersionedDynamicFilterDomains acknowledgeAndGetNewDynamicFilterDomains(TaskId var1, long var2);

    public void updateMemoryPoolAssignments(MemoryPoolAssignmentsRequest var1);

    public TaskInfo updateTask(Session var1, TaskId var2, Optional<PlanFragment> var3, List<TaskSource> var4, OutputBuffers var5, Map<DynamicFilterId, Domain> var6);

    public TaskInfo cancelTask(TaskId var1);

    public TaskInfo abortTask(TaskId var1);

    public TaskInfo failTask(TaskId var1, Throwable var2);

    public ListenableFuture<BufferResult> getTaskResults(TaskId var1, OutputBuffers.OutputBufferId var2, long var3, DataSize var5);

    public void acknowledgeTaskResults(TaskId var1, OutputBuffers.OutputBufferId var2, long var3);

    public TaskInfo abortTaskResults(TaskId var1, OutputBuffers.OutputBufferId var2);

    public void addStateChangeListener(TaskId var1, StateMachine.StateChangeListener<TaskState> var2);

    public void addSourceTaskFailureListener(TaskId var1, TaskFailureListener var2);

    public Optional<String> getTraceToken(TaskId var1);
}

