/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.operator.PagesHashStrategy;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.openjdk.jol.info.ClassLayout;

public class SimplePagesHashStrategy
implements PagesHashStrategy {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SimplePagesHashStrategy.class).instanceSize();
    private final List<Type> types;
    private final List<Optional<BlockTypeOperators.BlockPositionComparison>> comparisonOperators;
    private final List<Integer> outputChannels;
    private final List<List<Block>> channels;
    private final List<Integer> hashChannels;
    private final List<Block> precomputedHashChannel;
    private final Optional<Integer> sortChannel;
    private final List<BlockTypeOperators.BlockPositionEqual> equalOperators;
    private final List<BlockTypeOperators.BlockPositionHashCode> hashCodeOperators;
    private final List<BlockTypeOperators.BlockPositionIsDistinctFrom> isDistinctFromOperators;

    public SimplePagesHashStrategy(List<Type> types, List<Integer> outputChannels, List<List<Block>> channels, List<Integer> hashChannels, OptionalInt precomputedHashChannel, Optional<Integer> sortChannel, BlockTypeOperators blockTypeOperators) {
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.comparisonOperators = (List)types.stream().map(type -> type.isOrderable() ? Optional.of(blockTypeOperators.getComparisonUnorderedLastOperator((Type)type)) : Optional.empty()).collect(ImmutableList.toImmutableList());
        this.outputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputChannels, "outputChannels is null"));
        this.channels = ImmutableList.copyOf((Collection)Objects.requireNonNull(channels, "channels is null"));
        Preconditions.checkArgument((types.size() == channels.size() ? 1 : 0) != 0, (Object)"Expected types and channels to be the same length");
        this.hashChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashChannels, "hashChannels is null"));
        this.precomputedHashChannel = precomputedHashChannel.isPresent() ? channels.get(precomputedHashChannel.getAsInt()) : null;
        this.sortChannel = Objects.requireNonNull(sortChannel, "sortChannel is null");
        this.equalOperators = (List)hashChannels.stream().map(types::get).map(blockTypeOperators::getEqualOperator).collect(ImmutableList.toImmutableList());
        this.hashCodeOperators = (List)hashChannels.stream().map(types::get).map(blockTypeOperators::getHashCodeOperator).collect(ImmutableList.toImmutableList());
        this.isDistinctFromOperators = (List)hashChannels.stream().map(types::get).map(blockTypeOperators::getDistinctFromOperator).collect(ImmutableList.toImmutableList());
    }

    @Override
    public int getChannelCount() {
        return this.outputChannels.size();
    }

    @Override
    public long getSizeInBytes() {
        return (long)INSTANCE_SIZE + this.channels.stream().flatMap(Collection::stream).mapToLong(Block::getRetainedSizeInBytes).sum();
    }

    @Override
    public void appendTo(int blockIndex, int position, PageBuilder pageBuilder, int outputChannelOffset) {
        for (int outputIndex : this.outputChannels) {
            Type type = this.types.get(outputIndex);
            List<Block> channel = this.channels.get(outputIndex);
            Block block = channel.get(blockIndex);
            type.appendTo(block, position, pageBuilder.getBlockBuilder(outputChannelOffset));
            ++outputChannelOffset;
        }
    }

    @Override
    public long hashPosition(int blockIndex, int position) {
        if (this.precomputedHashChannel != null) {
            return BigintType.BIGINT.getLong(this.precomputedHashChannel.get(blockIndex), position);
        }
        long result = 0L;
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            Block block = this.channels.get(this.hashChannels.get(i)).get(blockIndex);
            result = result * 31L + this.hashCodeOperators.get(i).hashCodeNullSafe(block, position);
        }
        return result;
    }

    @Override
    public long hashRow(int position, Page page) {
        long result = 0L;
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            Block block = page.getBlock(i);
            result = result * 31L + this.hashCodeOperators.get(i).hashCodeNullSafe(block, position);
        }
        return result;
    }

    @Override
    public boolean rowEqualsRow(int leftPosition, Page leftPage, int rightPosition, Page rightPage) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            Block leftBlock = leftPage.getBlock(i);
            Block rightBlock = rightPage.getBlock(i);
            if (this.equalOperators.get(i).equalNullSafe(leftBlock, leftPosition, rightBlock, rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean rowNotDistinctFromRow(int leftPosition, Page leftPage, int rightPosition, Page rightPage) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            Block leftBlock = leftPage.getBlock(i);
            Block rightBlock = rightPage.getBlock(i);
            if (!this.isDistinctFromOperators.get(i).isDistinctFrom(leftBlock, leftPosition, rightBlock, rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionEqualsRow(int leftBlockIndex, int leftPosition, int rightPosition, Page rightPage) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            Block leftBlock = this.channels.get(this.hashChannels.get(i)).get(leftBlockIndex);
            Block rightBlock = rightPage.getBlock(i);
            if (this.equalOperators.get(i).equalNullSafe(leftBlock, leftPosition, rightBlock, rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionNotDistinctFromRow(int leftBlockIndex, int leftPosition, int rightPosition, Page rightPage) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            Block leftBlock = this.channels.get(this.hashChannels.get(i)).get(leftBlockIndex);
            Block rightBlock = rightPage.getBlock(i);
            if (!this.isDistinctFromOperators.get(i).isDistinctFrom(leftBlock, leftPosition, rightBlock, rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionEqualsRowIgnoreNulls(int leftBlockIndex, int leftPosition, int rightPosition, Page rightPage) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            Block rightBlock;
            Block leftBlock;
            BlockTypeOperators.BlockPositionEqual equalOperator = this.equalOperators.get(i);
            if (equalOperator.equal(leftBlock = this.channels.get(this.hashChannels.get(i)).get(leftBlockIndex), leftPosition, rightBlock = rightPage.getBlock(i), rightPosition).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionNotDistinctFromRow(int leftBlockIndex, int leftPosition, int rightPosition, Page page, int[] rightChannels) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            int hashChannel = this.hashChannels.get(i);
            Block leftBlock = this.channels.get(hashChannel).get(leftBlockIndex);
            Block rightBlock = page.getBlock(rightChannels[i]);
            BlockTypeOperators.BlockPositionIsDistinctFrom isDistinctFromOperator = this.isDistinctFromOperators.get(i);
            if (isDistinctFromOperator.isDistinctFrom(leftBlock, leftPosition, rightBlock, rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionEqualsPosition(int leftBlockIndex, int leftPosition, int rightBlockIndex, int rightPosition) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            List<Block> channel = this.channels.get(this.hashChannels.get(i));
            Block leftBlock = channel.get(leftBlockIndex);
            Block rightBlock = channel.get(rightBlockIndex);
            if (this.equalOperators.get(i).equalNullSafe(leftBlock, leftPosition, rightBlock, rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionNotDistinctFromPosition(int leftBlockIndex, int leftPosition, int rightBlockIndex, int rightPosition) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            List<Block> channel = this.channels.get(this.hashChannels.get(i));
            Block leftBlock = channel.get(leftBlockIndex);
            Block rightBlock = channel.get(rightBlockIndex);
            if (!this.isDistinctFromOperators.get(i).isDistinctFrom(leftBlock, leftPosition, rightBlock, rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionEqualsPositionIgnoreNulls(int leftBlockIndex, int leftPosition, int rightBlockIndex, int rightPosition) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            List<Block> channel = this.channels.get(this.hashChannels.get(i));
            Block leftBlock = channel.get(leftBlockIndex);
            Block rightBlock = channel.get(rightBlockIndex);
            if (this.equalOperators.get(i).equal(leftBlock, leftPosition, rightBlock, rightPosition).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPositionNull(int blockIndex, int blockPosition) {
        for (int hashChannel : this.hashChannels) {
            if (!this.isChannelPositionNull(hashChannel, blockIndex, blockPosition)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareSortChannelPositions(int leftBlockIndex, int leftBlockPosition, int rightBlockIndex, int rightBlockPosition) {
        int channel = this.getSortChannel();
        Block leftBlock = this.channels.get(channel).get(leftBlockIndex);
        Block rightBlock = this.channels.get(channel).get(rightBlockIndex);
        return (int)this.comparisonOperators.get(channel).orElseThrow(() -> new IllegalArgumentException("type is not orderable")).compare(leftBlock, leftBlockPosition, rightBlock, rightBlockPosition);
    }

    @Override
    public boolean isSortChannelPositionNull(int blockIndex, int blockPosition) {
        return this.isChannelPositionNull(this.getSortChannel(), blockIndex, blockPosition);
    }

    private boolean isChannelPositionNull(int channelIndex, int blockIndex, int blockPosition) {
        List<Block> channel = this.channels.get(channelIndex);
        Block block = channel.get(blockIndex);
        return block.isNull(blockPosition);
    }

    private int getSortChannel() {
        return this.sortChannel.get();
    }
}

