/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.trino.spi.function.AccumulatorState;

public interface CovarianceState
extends AccumulatorState {
    public long getCount();

    public void setCount(long var1);

    public double getMeanX();

    public void setMeanX(double var1);

    public double getMeanY();

    public void setMeanY(double var1);

    public double getC2();

    public void setC2(double var1);

    default public void update(double x, double y) {
        long n = this.getCount() + 1L;
        this.setCount(n);
        double oldMeanX = this.getMeanX();
        this.setMeanX(oldMeanX + (x - oldMeanX) / (double)n);
        double oldMeanY = this.getMeanY();
        double newMeanY = oldMeanY + (y - oldMeanY) / (double)n;
        this.setMeanY(newMeanY);
        this.setC2(this.getC2() + (x - oldMeanX) * (y - newMeanY));
    }

    default public void merge(CovarianceState otherState) {
        if (otherState.getCount() == 0L) {
            return;
        }
        long na = this.getCount();
        long nb = otherState.getCount();
        long n = na + nb;
        this.setCount(n);
        double meanX = this.getMeanX();
        double meanY = this.getMeanY();
        double deltaX = otherState.getMeanX() - meanX;
        double deltaY = otherState.getMeanY() - meanY;
        this.setC2(this.getC2() + otherState.getC2() + deltaX * deltaY * (double)na * (double)nb / (double)n);
        this.setMeanX(meanX + deltaX * (double)nb / (double)n);
        this.setMeanY(meanY + deltaY * (double)nb / (double)n);
    }

    default public double getCovarianceSample() {
        return this.getC2() / (double)(this.getCount() - 1L);
    }

    default public double getCovariancePopulation() {
        return this.getC2() / (double)this.getCount();
    }
}

