/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.exchange;

import com.google.common.util.concurrent.ListenableFuture;
import io.trino.operator.exchange.LocalExchangeMemoryManager;
import io.trino.operator.exchange.LocalExchangeSource;
import io.trino.operator.exchange.LocalExchanger;
import io.trino.operator.exchange.PageReference;
import io.trino.spi.Page;
import java.util.Objects;
import java.util.function.LongConsumer;

public class PassthroughExchanger
implements LocalExchanger {
    private final LocalExchangeSource localExchangeSource;
    private final LocalExchangeMemoryManager bufferMemoryManager;
    private final LongConsumer memoryTracker;
    private final PageReference.PageReleasedListener onPageReleased;

    public PassthroughExchanger(LocalExchangeSource localExchangeSource, long bufferMaxMemory, LongConsumer memoryTracker) {
        this.localExchangeSource = Objects.requireNonNull(localExchangeSource, "localExchangeSource is null");
        this.memoryTracker = Objects.requireNonNull(memoryTracker, "memoryTracker is null");
        this.bufferMemoryManager = new LocalExchangeMemoryManager(bufferMaxMemory);
        this.onPageReleased = releasedSizeInBytes -> {
            this.bufferMemoryManager.updateMemoryUsage(-releasedSizeInBytes);
            this.memoryTracker.accept(-releasedSizeInBytes);
        };
    }

    @Override
    public void accept(Page page) {
        PageReference pageReference = new PageReference(page, 1, this.onPageReleased);
        long retainedSizeInBytes = pageReference.getRetainedSizeInBytes();
        this.bufferMemoryManager.updateMemoryUsage(retainedSizeInBytes);
        this.memoryTracker.accept(retainedSizeInBytes);
        this.localExchangeSource.addPage(pageReference);
    }

    @Override
    public ListenableFuture<Void> waitForWriting() {
        return this.bufferMemoryManager.getNotFullFuture();
    }

    @Override
    public void finish() {
        this.localExchangeSource.finish();
    }
}

