/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class ArrayFlattenFunction
extends SqlScalarFunction {
    public static final ArrayFlattenFunction ARRAY_FLATTEN_FUNCTION = new ArrayFlattenFunction();
    private static final String FUNCTION_NAME = "flatten";
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayFlattenFunction.class, "flatten", Type.class, Type.class, Block.class);

    private ArrayFlattenFunction() {
        super(new FunctionMetadata(new Signature(FUNCTION_NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("E")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0])), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.arrayType((TypeSignature)TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0])))), false), new FunctionNullability(false, (List<Boolean>)ImmutableList.of((Object)false)), false, true, "Flattens the given array", FunctionKind.SCALAR));
    }

    @Override
    protected ScalarFunctionImplementation specialize(BoundSignature boundSignature) {
        ArrayType arrayType = (ArrayType)boundSignature.getReturnType();
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(arrayType.getElementType()).bindTo(arrayType);
        return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    public static Block flatten(Type type, Type arrayType, Block array) {
        if (array.getPositionCount() == 0) {
            return type.createBlockBuilder(null, 0).build();
        }
        BlockBuilder builder = type.createBlockBuilder(null, array.getPositionCount(), Math.toIntExact(array.getSizeInBytes() / (long)array.getPositionCount()));
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (array.isNull(i)) continue;
            Block subArray = (Block)arrayType.getObject(array, i);
            for (int j = 0; j < subArray.getPositionCount(); ++j) {
                type.appendTo(subArray, j, builder);
            }
        }
        return builder.build();
    }
}

