/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.SessionRepresentation;
import io.trino.security.AccessControl;
import io.trino.server.BasicQueryInfo;
import io.trino.spi.security.Identity;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class AccessControlUtil {
    private AccessControlUtil() {
    }

    public static void checkCanViewQueryOwnedBy(Identity identity, Identity queryOwner, AccessControl accessControl) {
        if (identity.getUser().equals(queryOwner.getUser())) {
            return;
        }
        accessControl.checkCanViewQueryOwnedBy(identity, queryOwner);
    }

    public static List<BasicQueryInfo> filterQueries(Identity identity, List<BasicQueryInfo> queries, AccessControl accessControl) {
        Collection<Identity> owners = (Collection<Identity>)queries.stream().map(BasicQueryInfo::getSession).map(SessionRepresentation::toIdentity).filter(owner -> !owner.getUser().equals(identity.getUser())).map(FullIdentityEquality::new).distinct().map(FullIdentityEquality::getIdentity).collect(ImmutableList.toImmutableList());
        owners = accessControl.filterQueriesOwnedBy(identity, owners);
        Set allowedOwners = (Set)owners.stream().map(FullIdentityEquality::new).collect(ImmutableSet.toImmutableSet());
        return (List)queries.stream().filter(queryInfo -> {
            Identity queryIdentity = queryInfo.getSession().toIdentity();
            return queryIdentity.getUser().equals(identity.getUser()) || allowedOwners.contains(new FullIdentityEquality(queryIdentity));
        }).collect(ImmutableList.toImmutableList());
    }

    public static void checkCanKillQueryOwnedBy(Identity identity, Identity queryOwner, AccessControl accessControl) {
        if (identity.getUser().equals(queryOwner.getUser())) {
            return;
        }
        accessControl.checkCanKillQueryOwnedBy(identity, queryOwner);
    }

    private static class FullIdentityEquality {
        private final Identity identity;

        public FullIdentityEquality(Identity identity) {
            this.identity = identity;
        }

        public Identity getIdentity() {
            return this.identity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FullIdentityEquality that = (FullIdentityEquality)o;
            return Objects.equals(this.identity.getUser(), that.identity.getUser()) && Objects.equals(this.identity.getGroups(), that.identity.getGroups()) && Objects.equals(this.identity.getPrincipal(), that.identity.getPrincipal()) && Objects.equals(this.identity.getEnabledRoles(), that.identity.getEnabledRoles()) && Objects.equals(this.identity.getCatalogRoles(), that.identity.getCatalogRoles());
        }

        public int hashCode() {
            return Objects.hash(this.identity.getUser(), this.identity.getGroups(), this.identity.getPrincipal(), this.identity.getEnabledRoles(), this.identity.getCatalogRoles());
        }
    }
}

