/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.trino.spi.type.TimeZoneKey;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public class SqlEnvironmentConfig {
    private Optional<String> path = Optional.empty();
    private Optional<String> defaultCatalog = Optional.empty();
    private Optional<String> defaultSchema = Optional.empty();
    private Optional<TimeZoneKey> forcedSessionTimeZone = Optional.empty();

    @NotNull
    public Optional<String> getPath() {
        return this.path;
    }

    @Config(value="sql.path")
    public SqlEnvironmentConfig setPath(String path) {
        this.path = Optional.ofNullable(path);
        return this;
    }

    @NotNull
    public Optional<String> getDefaultCatalog() {
        return this.defaultCatalog;
    }

    @Config(value="sql.default-catalog")
    public SqlEnvironmentConfig setDefaultCatalog(String catalog) {
        this.defaultCatalog = Optional.ofNullable(catalog);
        return this;
    }

    @NotNull
    public Optional<String> getDefaultSchema() {
        return this.defaultSchema;
    }

    @Config(value="sql.default-schema")
    public SqlEnvironmentConfig setDefaultSchema(String schema) {
        this.defaultSchema = Optional.ofNullable(schema);
        return this;
    }

    @NotNull
    public Optional<TimeZoneKey> getForcedSessionTimeZone() {
        return this.forcedSessionTimeZone;
    }

    @Config(value="sql.forced-session-time-zone")
    @ConfigDescription(value="User session time zone overriding value sent by client")
    public SqlEnvironmentConfig setForcedSessionTimeZone(@Nullable String timeZoneId) {
        this.forcedSessionTimeZone = Optional.ofNullable(timeZoneId).map(TimeZoneKey::getTimeZoneKey);
        return this;
    }
}

