/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import com.google.common.base.Verify;
import io.airlift.units.Duration;
import io.trino.execution.executor.PrioritizedSplitRunner;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class ExpressionProfiler {
    private static final Duration EXPENSIVE_EXPRESSION_THRESHOLD = PrioritizedSplitRunner.SPLIT_RUN_QUANTA;
    private static final int NOT_INITALIZED = -1;
    private final Ticker ticker;
    private final double expensiveExpressionThresholdNanos;
    private double totalExecutionTimeNanos;
    private int samples;
    private long previousTimestamp = -1L;
    private boolean isExpressionExpensive = true;

    public ExpressionProfiler() {
        this(Ticker.systemTicker(), EXPENSIVE_EXPRESSION_THRESHOLD);
    }

    @VisibleForTesting
    public ExpressionProfiler(Ticker ticker, Duration expensiveExpressionThreshold) {
        Objects.requireNonNull(ticker, "ticker is null");
        Objects.requireNonNull(expensiveExpressionThreshold, "expensiveExpressionThreshold is null");
        this.expensiveExpressionThresholdNanos = expensiveExpressionThreshold.getValue(TimeUnit.NANOSECONDS);
        this.ticker = ticker;
    }

    public void start() {
        this.previousTimestamp = this.ticker.read();
    }

    public void stop(int batchSize) {
        Verify.verify((this.previousTimestamp != -1L ? 1 : 0) != 0, (String)"start() is not called", (Object[])new Object[0]);
        Verify.verify((batchSize > 0 ? 1 : 0) != 0, (String)"batchSize must be positive", (Object[])new Object[0]);
        long now = this.ticker.read();
        long delta = now - this.previousTimestamp;
        this.totalExecutionTimeNanos += (double)delta;
        this.samples += batchSize;
        if (this.totalExecutionTimeNanos / (double)this.samples < this.expensiveExpressionThresholdNanos) {
            this.isExpressionExpensive = false;
        }
        this.previousTimestamp = -1L;
    }

    public boolean isExpressionExpensive() {
        return this.isExpressionExpensive;
    }
}

