/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.DefaultFileRegion;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultHttpContent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.LastHttpContent;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.AssembledFullHttpResponse;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.AssembledHttpResponse;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.AssembledLastHttpContent;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.VertxHttpResponse;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.headers.HeadersMultiMap;

final class VertxHttpResponseEncoder
extends HttpResponseEncoder {
    VertxHttpResponseEncoder() {
    }

    protected void encodeHeaders(HttpHeaders headers, ByteBuf buf) {
        if (headers instanceof HeadersMultiMap) {
            HeadersMultiMap vertxHeaders = (HeadersMultiMap)headers;
            vertxHeaders.encode(buf);
        } else {
            super.encodeHeaders(headers, buf);
        }
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        if (msg == Unpooled.EMPTY_BUFFER || msg == LastHttpContent.EMPTY_LAST_CONTENT) {
            return true;
        }
        Class<?> msgClazz = msg.getClass();
        if (msgClazz == AssembledFullHttpResponse.class || msgClazz == DefaultFullHttpResponse.class || msgClazz == AssembledHttpResponse.class || msgClazz == DefaultHttpContent.class || msgClazz == AssembledLastHttpContent.class || msgClazz == DefaultFileRegion.class) {
            return true;
        }
        return super.acceptOutboundMessage(msg);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
    }

    protected boolean isContentAlwaysEmpty(HttpResponse msg) {
        return msg instanceof VertxHttpResponse && ((VertxHttpResponse)msg).head() || super.isContentAlwaysEmpty(msg);
    }
}

