/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.impl;

import io.grpc.netty.shaded.io.netty.channel.EventLoop;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Promise;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.TaskQueue;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.WorkerTask;

class WorkerTaskQueue
extends TaskQueue {
    WorkerTaskQueue() {
    }

    void shutdown(final EventLoop executor, final Promise<Void> completion) {
        final TaskQueue.CloseResult closeResult = this.close();
        class InterruptSequence {
            InterruptSequence() {
            }

            void cancelActiveTask() {
                Thread activeThread = closeResult.activeThread();
                if (activeThread != null) {
                    activeThread.interrupt();
                    WorkerTask activeTask = (WorkerTask)closeResult.activeTask();
                    activeTask.onCompletion(() -> executor.execute(() -> this.cancelSuspended(0)));
                } else {
                    this.cancelSuspended(0);
                }
            }

            void cancelSuspended(int idx) {
                int num = closeResult.suspendedThreads().size();
                if (idx < num) {
                    Thread suspendedThread = closeResult.suspendedThreads().get(idx);
                    WorkerTask suspendedTask = (WorkerTask)closeResult.suspendedTasks().get(idx);
                    suspendedThread.interrupt();
                    suspendedTask.onCompletion(() -> executor.execute(() -> this.cancelSuspended(idx + 1)));
                } else {
                    completion.complete();
                }
            }
        }
        new InterruptSequence().cancelActiveTask();
    }
}

