/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl;

import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.handler.ssl.SniHandler;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler;
import io.grpc.netty.shaded.io.netty.util.AsyncMapping;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.HostAndPort;

class VertxSniHandler
extends SniHandler {
    private final Executor delegatedTaskExec;
    private final HostAndPort remoteAddress;

    public VertxSniHandler(AsyncMapping<? super String, ? extends SslContext> mapping, long handshakeTimeoutMillis, Executor delegatedTaskExec, HostAndPort remoteAddress) {
        super(mapping, handshakeTimeoutMillis);
        this.delegatedTaskExec = delegatedTaskExec;
        this.remoteAddress = remoteAddress;
    }

    protected SslHandler newSslHandler(SslContext context, ByteBufAllocator allocator) {
        SslHandler sslHandler = this.remoteAddress != null ? context.newHandler(allocator, this.remoteAddress.host(), this.remoteAddress.port(), this.delegatedTaskExec) : context.newHandler(allocator, this.delegatedTaskExec);
        sslHandler.setHandshakeTimeout(this.handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
        return sslHandler;
    }
}

