/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.pulsar.broker.resources.NamespaceResources;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.broker.resources.TenantResources;
import org.apache.pulsar.broker.service.schema.SchemaStorageFormat;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.docs.tools.CmdGenerateDocs;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.MetadataStoreFactory;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class PulsarClusterMetadataTeardown {
    public static String[] localZkNodes = new String[]{"bookies", "counters", "loadbalance", "managed-ledgers", "namespace", "schemas", "stream"};
    private static final Logger log = LoggerFactory.getLogger(PulsarClusterMetadataTeardown.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        CommandLine commander = new CommandLine((Object)arguments);
        try {
            commander.parseArgs(args);
            if (arguments.help) {
                commander.usage(commander.getOut());
                return;
            }
            if (arguments.generateDocs) {
                CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
                cmd.addCommand("delete-cluster-metadata", (Object)commander);
                cmd.run(null);
                return;
            }
        }
        catch (Exception e) {
            commander.getErr().println(e);
            throw e;
        }
        if (arguments.metadataStoreUrl == null && arguments.zookeeper == null) {
            commander.usage(commander.getOut());
            throw new IllegalArgumentException("Metadata store address argument is required (--metadata-store)");
        }
        if (arguments.metadataStoreUrl == null) {
            arguments.metadataStoreUrl = "zk:" + arguments.zookeeper;
        }
        MetadataStoreExtended metadataStore = MetadataStoreExtended.create((String)arguments.metadataStoreUrl, (MetadataStoreConfig)MetadataStoreConfig.builder().sessionTimeoutMillis(arguments.zkSessionTimeoutMillis).metadataStoreName("metadata-store").configFilePath(arguments.metadataStoreConfigPath).build());
        try {
            if (arguments.bkMetadataServiceUri != null) {
                BookKeeper bookKeeper = new BookKeeper((ClientConfiguration)new ClientConfiguration().setMetadataServiceUri(arguments.bkMetadataServiceUri));
                try {
                    ManagedLedgerFactoryImpl managedLedgerFactory = new ManagedLedgerFactoryImpl(metadataStore, bookKeeper);
                    try {
                        PulsarClusterMetadataTeardown.deleteManagedLedgers((MetadataStore)metadataStore, (ManagedLedgerFactory)managedLedgerFactory);
                        PulsarClusterMetadataTeardown.deleteSchemaLedgers((MetadataStore)metadataStore, bookKeeper);
                    }
                    finally {
                        if (Collections.singletonList(managedLedgerFactory).get(0) != null) {
                            managedLedgerFactory.shutdown();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(bookKeeper).get(0) != null) {
                        bookKeeper.close();
                    }
                }
            }
            for (BookKeeper localZkNode : localZkNodes) {
                PulsarClusterMetadataTeardown.deleteRecursively((MetadataStore)metadataStore, "/" + (String)localZkNode).join();
            }
            if (arguments.configurationStore != null && arguments.cluster != null) {
                MetadataStore configMetadataStore = MetadataStoreFactory.create((String)arguments.configurationStore, (MetadataStoreConfig)MetadataStoreConfig.builder().sessionTimeoutMillis(arguments.zkSessionTimeoutMillis).configFilePath(arguments.configurationStoreConfigPath).metadataStoreName("configuration-metadata-store").build());
                try {
                    PulsarResources resources = new PulsarResources((MetadataStore)metadataStore, configMetadataStore);
                    TenantResources tenantResources = resources.getTenantResources();
                    NamespaceResources namespaceResources = resources.getNamespaceResources();
                    List tenants = tenantResources.listTenants();
                    for (String tenant : tenants) {
                        List namespaces = (List)namespaceResources.listNamespacesAsync(tenant).get();
                        for (String namespace : namespaces) {
                            namespaceResources.setPolicies(NamespaceName.get((String)tenant, (String)namespace), policies -> {
                                policies.replication_clusters.remove(arguments.cluster);
                                return policies;
                            });
                        }
                        PulsarClusterMetadataTeardown.removeCurrentClusterFromAllowedClusters(tenantResources, tenant, arguments.cluster);
                    }
                    try {
                        resources.getClusterResources().deleteCluster(arguments.cluster);
                    }
                    catch (MetadataStoreException.NotFoundException ex) {
                        log.info("Cluster metadata for '{}' does not exist.", (Object)arguments.cluster);
                    }
                }
                finally {
                    if (Collections.singletonList(configMetadataStore).get(0) != null) {
                        configMetadataStore.close();
                    }
                }
            }
            log.info("Cluster metadata for '{}' teardown.", (Object)arguments.cluster);
        }
        finally {
            if (Collections.singletonList(metadataStore).get(0) != null) {
                metadataStore.close();
            }
        }
    }

    private static void removeCurrentClusterFromAllowedClusters(TenantResources tenantResources, String tenant, String curCluster) throws MetadataStoreException, InterruptedException, ExecutionException {
        Optional tenantInfoOptional = tenantResources.getTenant(tenant);
        if (tenantInfoOptional.isEmpty()) {
            return;
        }
        tenantResources.updateTenantAsync(tenant, ti -> {
            ti.getAllowedClusters().remove(curCluster);
            return ti;
        }).get();
    }

    private static CompletableFuture<Void> deleteRecursively(MetadataStore metadataStore, String path) {
        return ((CompletableFuture)((CompletableFuture)metadataStore.getChildren(path).thenCompose(children -> FutureUtil.waitForAll((Collection)children.stream().map(child -> PulsarClusterMetadataTeardown.deleteRecursively(metadataStore, path + "/" + child)).collect(Collectors.toList())))).thenCompose(__ -> metadataStore.exists(path))).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return metadataStore.delete(path, Optional.empty());
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private static void deleteLedger(BookKeeper bookKeeper, long ledgerId) {
        try {
            bookKeeper.deleteLedger(ledgerId);
            if (log.isDebugEnabled()) {
                log.debug("Delete ledger id: {}", (Object)ledgerId);
            }
        }
        catch (InterruptedException | BKException ex) {
            if (ex instanceof BKException) {
                BKException bkException = (BKException)ex;
                switch (bkException.getCode()) {
                    case -25: 
                    case -7: {
                        log.warn("Failed to delete deleted ledger. ledgerId={} errorCode={}", (Object)ledgerId, (Object)bkException.getCode());
                        return;
                    }
                }
            }
            log.error("Failed to delete ledger {}: {}", (Object)ledgerId, (Object)ex);
            throw new RuntimeException(ex);
        }
    }

    private static void deleteManagedLedgers(MetadataStore metadataStore, ManagedLedgerFactory managedLedgerFactory) {
        String managedLedgersRoot = "/managed-ledgers";
        ((List)metadataStore.getChildren("/managed-ledgers").join()).forEach(tenant -> {
            String tenantRoot = "/managed-ledgers/" + tenant;
            ((List)metadataStore.getChildren(tenantRoot).join()).forEach(namespace -> {
                String namespaceRoot = String.join((CharSequence)"/", tenantRoot, namespace, "persistent");
                ((List)metadataStore.getChildren(namespaceRoot).join()).forEach(topic -> {
                    TopicName topicName = TopicName.get((String)String.join((CharSequence)"/", tenant, namespace, topic));
                    try {
                        managedLedgerFactory.delete(topicName.getPersistenceNamingEncoding());
                    }
                    catch (InterruptedException | ManagedLedgerException e) {
                        log.error("Failed to delete ledgers of {}: {}", (Object)topicName, (Object)e);
                        throw new RuntimeException(e);
                    }
                });
            });
        });
    }

    private static void deleteSchemaLedgers(MetadataStore metadataStore, BookKeeper bookKeeper) {
        String schemaLedgersRoot = "/schemas";
        ((List)metadataStore.getChildren("/schemas").join()).forEach(tenant -> {
            String tenantRoot = "/schemas/" + tenant;
            ((List)metadataStore.getChildren(tenantRoot).join()).forEach(namespace -> {
                String namespaceRoot = tenantRoot + "/" + namespace;
                ((List)metadataStore.getChildren(namespaceRoot).join()).forEach(topic -> {
                    String topicRoot = namespaceRoot + "/" + topic;
                    try {
                        SchemaStorageFormat.SchemaLocator.parseFrom(((GetResult)((Optional)metadataStore.get(topicRoot).join()).get()).getValue()).getIndexList().stream().map(indexEntry -> indexEntry.getPosition().getLedgerId()).forEach(ledgerId -> PulsarClusterMetadataTeardown.deleteLedger(bookKeeper, ledgerId));
                    }
                    catch (InvalidProtocolBufferException e) {
                        log.warn("Invalid data format from {}: {}", (Object)topicRoot, (Object)e);
                    }
                });
            });
        });
    }

    @CommandLine.Command(name="delete-cluster-metadata", showDefaultValues=true, scope=CommandLine.ScopeType.INHERIT)
    private static class Arguments {
        @CommandLine.Option(names={"-zk", "--zookeeper"}, description={"Local ZooKeeper quorum connection string"})
        private String zookeeper;
        @CommandLine.Option(names={"-md", "--metadata-store"}, description={"Metadata Store service url. eg: zk:my-zk:2181"})
        private String metadataStoreUrl;
        @CommandLine.Option(names={"-mscp", "--metadata-store-config-path"}, description={"Metadata Store config path"})
        private String metadataStoreConfigPath;
        @CommandLine.Option(names={"--zookeeper-session-timeout-ms"}, description={"Local zookeeper session timeout ms"})
        private int zkSessionTimeoutMillis = 30000;
        @CommandLine.Option(names={"-c", "-cluster", "--cluster"}, description={"Cluster name"})
        private String cluster;
        @CommandLine.Option(names={"-cs", "--configuration-store"}, description={"Configuration Store connection string"})
        private String configurationStore;
        @CommandLine.Option(names={"-cmscp", "--configuration-metadata-store-config-path"}, description={"Configuration Metadata Store config path"}, hidden=false)
        private String configurationStoreConfigPath;
        @CommandLine.Option(names={"--bookkeeper-metadata-service-uri"}, description={"Metadata service uri of BookKeeper"})
        private String bkMetadataServiceUri;
        @CommandLine.Option(names={"-h", "--help"}, description={"Show this help message"})
        private boolean help = false;
        @CommandLine.Option(names={"-g", "--generate-docs"}, description={"Generate docs"})
        private boolean generateDocs = false;

        private Arguments() {
        }
    }
}

