/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.pulsar.broker.loadbalance.impl.LoadManagerShared;

public class BundleRangeCache {
    private final Map<String, Map<String, Set<String>>> data = new ConcurrentHashMap<String, Map<String, Set<String>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadFromBundles(String broker, Stream<String> bundles) {
        Map namespaceToBundleRange;
        Map map = namespaceToBundleRange = this.data.computeIfAbsent(broker, __ -> new HashMap());
        synchronized (map) {
            namespaceToBundleRange.clear();
            bundles.forEach(bundleName -> {
                String namespace = LoadManagerShared.getNamespaceNameFromBundleName(bundleName);
                String bundleRange = LoadManagerShared.getBundleRangeFromBundleName(bundleName);
                namespaceToBundleRange.computeIfAbsent(namespace, __ -> new HashSet()).add(bundleRange);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String broker, String namespace, String bundleRange) {
        Map namespaceToBundleRange;
        Map map = namespaceToBundleRange = this.data.computeIfAbsent(broker, __ -> new HashMap());
        synchronized (map) {
            namespaceToBundleRange.computeIfAbsent(namespace, __ -> new HashSet()).add(bundleRange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBundleRangeCount(String broker, String namespace) {
        Map namespaceToBundleRange;
        Map map = namespaceToBundleRange = this.data.computeIfAbsent(broker, __ -> new HashMap());
        synchronized (map) {
            Set bundleRangeSet = (Set)namespaceToBundleRange.get(namespace);
            return bundleRangeSet != null ? bundleRangeSet.size() : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getBrokerToNamespacesMap() {
        HashMap<String, List<String>> brokerToNamespaces = new HashMap<String, List<String>>();
        for (Map.Entry<String, Map<String, Set<String>>> entry : this.data.entrySet()) {
            Map<String, Set<String>> namespaceToBundleRange;
            String broker = entry.getKey();
            Map<String, Set<String>> map = namespaceToBundleRange = entry.getValue();
            synchronized (map) {
                brokerToNamespaces.put(broker, namespaceToBundleRange.keySet().stream().toList());
            }
        }
        return brokerToNamespaces;
    }
}

