/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.RawMessage;
import org.apache.pulsar.client.impl.RawBatchConverter;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.compaction.AbstractTwoPhaseCompactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishingOrderCompactor
extends AbstractTwoPhaseCompactor<MessageId> {
    private static final Logger log = LoggerFactory.getLogger(PublishingOrderCompactor.class);

    public PublishingOrderCompactor(ServiceConfiguration conf, PulsarClient pulsar, BookKeeper bk, ScheduledExecutorService scheduler) {
        super(conf, pulsar, bk, scheduler);
    }

    @Override
    protected Map<String, MessageId> toLatestMessageIdForKey(Map<String, MessageId> latestForKey) {
        return latestForKey;
    }

    @Override
    protected boolean compactMessage(String topic, Map<String, MessageId> latestForKey, RawMessage m, MessageMetadata metadata, MessageId id) {
        boolean deletedMessage = false;
        boolean replaceMessage = false;
        Pair<String, Integer> keyAndSize = this.extractKeyAndSize(m, metadata);
        if (keyAndSize != null) {
            if ((Integer)keyAndSize.getRight() > 0) {
                MessageId old = latestForKey.put((String)keyAndSize.getLeft(), id);
                replaceMessage = old != null;
            } else {
                deletedMessage = true;
                latestForKey.remove(keyAndSize.getLeft());
            }
        } else if (!this.topicCompactionRetainNullKey) {
            deletedMessage = true;
        }
        if (replaceMessage || deletedMessage) {
            this.mxBean.addCompactionRemovedEvent(topic);
        }
        return deletedMessage;
    }

    @Override
    protected boolean compactBatchMessage(String topic, Map<String, MessageId> latestForKey, RawMessage m, MessageMetadata metadata, MessageId id) {
        boolean deletedMessage = false;
        try {
            int numMessagesInBatch = metadata.getNumMessagesInBatch();
            int deleteCnt = 0;
            for (ImmutableTriple<MessageId, String, Integer> e : this.extractIdsAndKeysAndSizeFromBatch(m, metadata)) {
                if (e == null) continue;
                if (e.getMiddle() == null) {
                    if (this.topicCompactionRetainNullKey) continue;
                    ++deleteCnt;
                    this.mxBean.addCompactionRemovedEvent(topic);
                    continue;
                }
                if ((Integer)e.getRight() > 0) {
                    MessageId old = latestForKey.put((String)e.getMiddle(), (MessageId)e.getLeft());
                    if (old == null) continue;
                    this.mxBean.addCompactionRemovedEvent(topic);
                    continue;
                }
                latestForKey.remove(e.getMiddle());
                ++deleteCnt;
                this.mxBean.addCompactionRemovedEvent(topic);
            }
            if (deleteCnt == numMessagesInBatch) {
                deletedMessage = true;
            }
        }
        catch (IOException ioe) {
            log.info("Error decoding batch for message {}. Whole batch will be included in output", (Object)id, (Object)ioe);
        }
        return deletedMessage;
    }

    protected List<ImmutableTriple<MessageId, String, Integer>> extractIdsAndKeysAndSizeFromBatch(RawMessage msg, MessageMetadata metadata) throws IOException {
        return RawBatchConverter.extractIdsAndKeysAndSize(msg, metadata);
    }
}

