/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisableDebugHttpMethodFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DisableDebugHttpMethodFilter.class);
    private final ServiceConfiguration serviceConfiguration;

    public DisableDebugHttpMethodFilter(ServiceConfiguration serviceConfiguration) {
        this.serviceConfiguration = serviceConfiguration;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.serviceConfiguration.isDisableHttpDebugMethods()) {
            if ("TRACE".equalsIgnoreCase(httpRequest.getMethod())) {
                httpResponse.setStatus(405);
                log.info("[{}] Rejected HTTP request using TRACE Method", (Object)request.getRemoteAddr());
                return;
            }
            if ("TRACK".equalsIgnoreCase(httpRequest.getMethod())) {
                httpResponse.setStatus(405);
                log.info("[{}] Rejected HTTP request using TRACK Method", (Object)request.getRemoteAddr());
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig arg) throws ServletException {
    }

    public void destroy() {
    }
}

