/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetty.tls;

import java.util.Set;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.pulsar.common.util.PulsarSslFactory;
import org.apache.pulsar.common.util.SecurityUtility;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettySslContextFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JettySslContextFactory.class);

    public static SslContextFactory.Server createSslContextFactory(String sslProviderString, PulsarSslFactory pulsarSslFactory, boolean requireTrustedClientCertOnConnect, Set<String> ciphers, Set<String> protocols) {
        return new Server(sslProviderString, pulsarSslFactory, requireTrustedClientCertOnConnect, ciphers, protocols);
    }

    static {
        if (SecurityUtility.CONSCRYPT_PROVIDER != null) {
            // empty if block
        }
    }

    private static class Server
    extends SslContextFactory.Server {
        private final PulsarSslFactory pulsarSslFactory;

        public Server(String sslProviderString, PulsarSslFactory pulsarSslFactory, boolean requireTrustedClientCertOnConnect, Set<String> ciphers, Set<String> protocols) {
            this.pulsarSslFactory = pulsarSslFactory;
            if (ciphers != null && ciphers.size() > 0) {
                this.setIncludeCipherSuites(ciphers.toArray(new String[0]));
            }
            if (protocols != null && protocols.size() > 0) {
                this.setIncludeProtocols(protocols.toArray(new String[0]));
            }
            if (sslProviderString != null && !sslProviderString.equals("")) {
                this.setProvider(sslProviderString);
            }
            if (requireTrustedClientCertOnConnect) {
                this.setNeedClientAuth(true);
                this.setTrustAll(false);
            } else {
                this.setWantClientAuth(true);
                this.setTrustAll(true);
            }
        }

        public SSLContext getSslContext() {
            return this.pulsarSslFactory.getInternalSslContext();
        }
    }
}

