/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.manager;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.prometheus.client.Histogram;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitState;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateData;
import org.apache.pulsar.broker.loadbalance.extensions.manager.StateChangeListener;
import org.apache.pulsar.broker.loadbalance.extensions.models.UnloadCounter;
import org.apache.pulsar.broker.loadbalance.extensions.models.UnloadDecision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnloadManager
implements StateChangeListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnloadManager.class);
    private final UnloadCounter counter;
    private final Map<String, CompletableFuture<Void>> inFlightUnloadRequest;
    private final String brokerId;

    public UnloadManager(UnloadCounter counter, String brokerId) {
        this.counter = counter;
        this.brokerId = Objects.requireNonNull(brokerId);
        this.inFlightUnloadRequest = new ConcurrentHashMap<String, CompletableFuture<Void>>();
    }

    private void complete(String serviceUnit, Throwable ex) {
        LatencyMetric.UNLOAD.endMeasurement(serviceUnit);
        LatencyMetric.DISCONNECT.endMeasurement(serviceUnit);
        if (ex != null) {
            LatencyMetric.RELEASE.endMeasurement(serviceUnit);
            LatencyMetric.ASSIGN.endMeasurement(serviceUnit);
        }
        this.inFlightUnloadRequest.computeIfPresent(serviceUnit, (__, future) -> {
            if (!future.isDone()) {
                if (ex != null) {
                    future.completeExceptionally(ex);
                } else {
                    future.complete(null);
                }
            }
            return null;
        });
    }

    public CompletableFuture<Void> waitAsync(CompletableFuture<Void> eventPubFuture, String bundle, UnloadDecision decision, long timeout, TimeUnit timeoutUnit) {
        return ((CompletableFuture)eventPubFuture.thenCompose(__ -> this.inFlightUnloadRequest.computeIfAbsent(bundle, ignore -> {
            if (log.isDebugEnabled()) {
                log.debug("Handle unload bundle: {}, timeout: {} {}", new Object[]{bundle, timeout, timeoutUnit});
            }
            CompletableFuture future = new CompletableFuture();
            future.orTimeout(timeout, timeoutUnit).whenComplete((v, ex) -> {
                if (ex != null) {
                    this.inFlightUnloadRequest.remove(bundle);
                    log.warn("Failed to wait unload for serviceUnit: {}", (Object)bundle, ex);
                }
            });
            return future;
        }))).whenComplete((__, ex) -> {
            if (ex != null) {
                this.counter.update(UnloadDecision.Label.Failure, UnloadDecision.Reason.Unknown);
                log.warn("Failed to unload bundle: {}", (Object)bundle, ex);
                return;
            }
            log.info("Complete unload bundle: {}", (Object)bundle);
            this.counter.update(decision);
        });
    }

    @Override
    public void beforeEvent(String serviceUnit, ServiceUnitStateData data) {
        if (log.isDebugEnabled()) {
            log.debug("Handling arrival of {} for service unit {}", (Object)data, (Object)serviceUnit);
        }
        ServiceUnitState state = ServiceUnitStateData.state(data);
        switch (state) {
            case Free: 
            case Owned: {
                LatencyMetric.DISCONNECT.beginMeasurement(serviceUnit, this.brokerId, data);
                break;
            }
            case Releasing: {
                LatencyMetric.RELEASE.beginMeasurement(serviceUnit, this.brokerId, data);
                LatencyMetric.UNLOAD.beginMeasurement(serviceUnit, this.brokerId, data);
                break;
            }
            case Assigning: {
                LatencyMetric.ASSIGN.beginMeasurement(serviceUnit, this.brokerId, data);
            }
        }
    }

    @Override
    public void handleEvent(String serviceUnit, ServiceUnitStateData data, Throwable t) {
        ServiceUnitState state = ServiceUnitStateData.state(data);
        if ((state == ServiceUnitState.Owned || state == ServiceUnitState.Assigning) && StringUtils.isBlank((CharSequence)data.sourceBroker())) {
            if (log.isDebugEnabled()) {
                log.debug("Skipping {} for service unit {} from the assignment command.", (Object)data, (Object)serviceUnit);
            }
            return;
        }
        if (t != null) {
            if (log.isDebugEnabled()) {
                log.debug("Handling {} for service unit {} with exception.", new Object[]{data, serviceUnit, t});
            }
            this.complete(serviceUnit, t);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Handling {} for service unit {}", (Object)data, (Object)serviceUnit);
        }
        switch (state) {
            case Free: {
                if (data.force()) break;
                this.complete(serviceUnit, t);
                break;
            }
            case Init: {
                Preconditions.checkArgument((data == null ? 1 : 0) != 0, (Object)"Init state must be associated with null data");
                this.complete(serviceUnit, t);
                break;
            }
            case Owned: {
                this.complete(serviceUnit, t);
                break;
            }
            case Releasing: {
                LatencyMetric.RELEASE.endMeasurement(serviceUnit);
                break;
            }
            case Assigning: {
                LatencyMetric.ASSIGN.endMeasurement(serviceUnit);
            }
        }
    }

    public void close() {
        this.inFlightUnloadRequest.forEach((bundle, future) -> {
            if (!future.isDone()) {
                String msg = String.format("Unloading bundle: %s, but the unload manager already closed.", bundle);
                log.warn(msg);
                future.completeExceptionally(new IllegalStateException(msg));
            }
        });
        this.inFlightUnloadRequest.clear();
    }

    @VisibleForTesting
    public static enum LatencyMetric {
        UNLOAD(LatencyMetric.buildHistogram("brk_lb_unload_latency", "Total time duration of unload operations on source brokers"), true, false),
        ASSIGN(LatencyMetric.buildHistogram("brk_lb_assign_latency", "Time spent in the load balancing ASSIGN state on destination brokers"), false, true),
        RELEASE(LatencyMetric.buildHistogram("brk_lb_release_latency", "Time spent in the load balancing RELEASE state on source brokers"), true, false),
        DISCONNECT(LatencyMetric.buildHistogram("brk_lb_disconnect_latency", "Time spent in the load balancing disconnected state on source brokers"), true, false);

        private static final long OP_TIMEOUT_NS;
        private final Histogram histogram;
        private final Map<String, CompletableFuture<Void>> futures = new ConcurrentHashMap<String, CompletableFuture<Void>>();
        private final boolean isSourceBrokerMetric;
        private final boolean isDestinationBrokerMetric;

        private static Histogram buildHistogram(String name, String help) {
            return (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build((String)name, (String)help).unit("ms")).labelNames(new String[]{"broker", "metric"})).buckets(new double[]{1.0, 10.0, 100.0, 200.0, 1000.0}).register();
        }

        private LatencyMetric(Histogram histogram, boolean isSourceBrokerMetric, boolean isDestinationBrokerMetric) {
            this.histogram = histogram;
            this.isSourceBrokerMetric = isSourceBrokerMetric;
            this.isDestinationBrokerMetric = isDestinationBrokerMetric;
        }

        public void beginMeasurement(String serviceUnit, String brokerId, ServiceUnitStateData data) {
            if (this.isSourceBrokerMetric && brokerId.equals(data.sourceBroker()) || this.isDestinationBrokerMetric && brokerId.equals(data.dstBroker())) {
                long startTimeNs = System.nanoTime();
                this.futures.computeIfAbsent(serviceUnit, ignore -> {
                    CompletableFuture<Object> future = new CompletableFuture<Object>();
                    ((CompletableFuture)future.completeOnTimeout(null, OP_TIMEOUT_NS, TimeUnit.NANOSECONDS).thenAccept(__ -> {
                        long durationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs);
                        log.info("Operation {} for service unit {} took {} ms", new Object[]{this, serviceUnit, durationMs});
                        ((Histogram.Child)this.histogram.labels(new String[]{brokerId, "bundleUnloading"})).observe((double)durationMs);
                    })).whenComplete((__, throwable) -> this.futures.remove(serviceUnit, future));
                    return future;
                });
            }
        }

        public void endMeasurement(String serviceUnit) {
            CompletableFuture<Void> future = this.futures.get(serviceUnit);
            if (future != null) {
                future.complete(null);
            }
        }

        static {
            OP_TIMEOUT_NS = TimeUnit.HOURS.toNanos(1L);
        }
    }
}

