/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.ToLongFunction;
import lombok.Generated;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.pulsar.common.api.proto.MarkersMessageIdData;
import org.apache.pulsar.common.api.proto.ReplicatedSubscriptionsSnapshot;
import org.apache.pulsar.common.util.StringInterner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedSubscriptionSnapshotCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReplicatedSubscriptionSnapshotCache.class);
    private final String subscription;
    private final ToLongFunction<Range<Position>> distanceFunction;
    private final int maxSnapshotToCache;
    private SnapshotEntry head;
    private SnapshotEntry tail;
    private int numberOfSnapshots = 0;
    private SnapshotEntry lastSortedEntry;
    private final SortedSet<SnapshotEntry> sortedSnapshots;

    public ReplicatedSubscriptionSnapshotCache(String subscription, int maxSnapshotToCache, ToLongFunction<Range<Position>> distanceFunction) {
        this.subscription = subscription;
        this.distanceFunction = distanceFunction;
        if (maxSnapshotToCache < 3) {
            throw new IllegalArgumentException("maxSnapshotToCache must be >= 3");
        }
        this.maxSnapshotToCache = maxSnapshotToCache;
        this.sortedSnapshots = new TreeSet<SnapshotEntry>();
    }

    public synchronized void addNewSnapshot(ReplicatedSubscriptionsSnapshot snapshot) {
        List<ClusterEntry> clusterEntryList;
        MarkersMessageIdData msgId = snapshot.getLocalMessageId();
        Position position = PositionFactory.create((long)msgId.getLedgerId(), (long)msgId.getEntryId());
        if (this.tail != null && position.compareTo(this.tail.position) <= 0) {
            this.head = null;
            this.tail = null;
            this.numberOfSnapshots = 0;
            this.sortedSnapshots.clear();
            this.lastSortedEntry = null;
        }
        if ((clusterEntryList = snapshot.getClustersList().stream().map(cmid -> {
            Position clusterPosition = PositionFactory.create((long)cmid.getMessageId().getLedgerId(), (long)cmid.getMessageId().getEntryId());
            if (clusterPosition.equals((Object)position)) {
                clusterPosition = position;
            }
            return new ClusterEntry(StringInterner.intern((String)cmid.getCluster()), clusterPosition);
        }).toList()).size() == 2) {
            clusterEntryList = List.of(clusterEntryList.get(0), clusterEntryList.get(1));
        } else if (clusterEntryList.size() == 3) {
            clusterEntryList = List.of(clusterEntryList.get(0), clusterEntryList.get(1), clusterEntryList.get(2));
        }
        SnapshotEntry entry = new SnapshotEntry(position, clusterEntryList);
        if (log.isDebugEnabled()) {
            log.debug("[{}] Added new replicated-subscription snapshot at {} -- {}", new Object[]{this.subscription, position, snapshot.getSnapshotId()});
        }
        if (this.head == null) {
            this.head = entry;
            this.tail = entry;
            entry.setDistanceToPrevious(0L);
        } else {
            this.tail.setNext(entry);
            entry.setPrev(this.tail);
            this.tail = entry;
        }
        ++this.numberOfSnapshots;
        if (this.numberOfSnapshots > this.maxSnapshotToCache) {
            this.removeSingleEntryWithMinimumTotalDistanceToPreviousAndNext();
        }
    }

    private void removeSingleEntryWithMinimumTotalDistanceToPreviousAndNext() {
        this.updateSortedEntriesByTotalDistance();
        SnapshotEntry minEntry = this.sortedSnapshots.first();
        if (minEntry == this.head || minEntry == this.tail) {
            throw new IllegalStateException("minEntry should not be head or tail boundary entry");
        }
        SnapshotEntry minEntryNext = minEntry.next;
        SnapshotEntry minEntryPrevious = minEntry.prev;
        this.sortedSnapshots.remove(minEntry);
        if (minEntryNext != this.tail) {
            this.sortedSnapshots.remove(minEntryNext);
        }
        if (minEntryPrevious != this.head) {
            this.sortedSnapshots.remove(minEntryPrevious);
        }
        minEntryPrevious.setNext(minEntryNext);
        minEntryNext.setPrev(minEntryPrevious);
        --this.numberOfSnapshots;
        if (this.lastSortedEntry == minEntry) {
            this.lastSortedEntry = minEntryPrevious;
        }
        minEntryNext.setDistanceToPrevious(minEntryNext.distanceToPrevious + minEntry.distanceToPrevious);
        if (minEntryNext != this.tail) {
            this.sortedSnapshots.add(minEntryNext);
        }
        if (minEntryPrevious != this.head) {
            this.sortedSnapshots.add(minEntryPrevious);
        }
    }

    private void updateSortedEntriesByTotalDistance() {
        SnapshotEntry current = this.lastSortedEntry != null ? this.lastSortedEntry.next : this.head.next;
        SnapshotEntry previousLoopEntry = null;
        while (current != null) {
            if (current.distanceToPrevious == -1L) {
                long distanceToPrevious = this.distanceFunction.applyAsLong((Range<Position>)Range.open((Comparable)current.prev.position, (Comparable)current.position));
                current.setDistanceToPrevious(distanceToPrevious);
            }
            if (previousLoopEntry != null) {
                this.sortedSnapshots.add(previousLoopEntry);
                this.lastSortedEntry = previousLoopEntry;
            }
            previousLoopEntry = current;
            current = current.next;
        }
    }

    public synchronized SnapshotResult advancedMarkDeletePosition(Position pos) {
        SnapshotEntry snapshot = null;
        SnapshotEntry current = this.head;
        while (current != null) {
            if (current.position.compareTo(pos) > 0) {
                if (!log.isDebugEnabled()) break;
                log.debug("[{}] Snapshot {} is associated with a higher position {} so it cannot be used for mark delete position {}", new Object[]{this.subscription, current, current.position, pos});
                break;
            }
            snapshot = current;
            if (current == this.lastSortedEntry) {
                this.lastSortedEntry = null;
            }
            this.head = current = current.next;
            if (this.head != null) {
                this.sortedSnapshots.remove(this.head);
            }
            --this.numberOfSnapshots;
        }
        if (this.head == null) {
            this.tail = null;
        } else {
            this.head.setPrev(null);
            this.head.setDistanceToPrevious(0L);
        }
        if (log.isDebugEnabled()) {
            if (snapshot != null) {
                log.debug("[{}] Advanced mark-delete position to {} -- found snapshot at {}", new Object[]{this.subscription, pos, snapshot.position()});
            } else {
                log.debug("[{}] Advanced mark-delete position to {} -- snapshot not found", (Object)this.subscription, (Object)pos);
            }
        }
        return snapshot != null ? new SnapshotResult(snapshot.position(), snapshot.clusters()) : null;
    }

    @VisibleForTesting
    synchronized List<SnapshotEntry> getSnapshots() {
        ArrayList<SnapshotEntry> snapshots = new ArrayList<SnapshotEntry>(this.numberOfSnapshots);
        SnapshotEntry current = this.head;
        while (current != null) {
            snapshots.add(current);
            current = current.next;
        }
        return snapshots;
    }

    @VisibleForTesting
    synchronized int size() {
        return this.numberOfSnapshots;
    }

    static class SnapshotEntry
    implements Comparable<SnapshotEntry> {
        private final Position position;
        private final List<ClusterEntry> clusters;
        private long distanceToPrevious = -1L;
        private SnapshotEntry next;
        private SnapshotEntry prev;

        SnapshotEntry(Position position, List<ClusterEntry> clusters) {
            this.position = position;
            this.clusters = clusters;
        }

        Position position() {
            return this.position;
        }

        List<ClusterEntry> clusters() {
            return this.clusters;
        }

        long distanceToPrevious() {
            return this.distanceToPrevious;
        }

        void setDistanceToPrevious(long distanceToPrevious) {
            this.distanceToPrevious = distanceToPrevious;
        }

        SnapshotEntry next() {
            return this.next;
        }

        void setNext(SnapshotEntry next) {
            this.next = next;
        }

        SnapshotEntry prev() {
            return this.prev;
        }

        void setPrev(SnapshotEntry prev) {
            this.prev = prev;
        }

        long totalDistance() {
            return this.distanceToPrevious + (this.next != null ? this.next.distanceToPrevious : 0L);
        }

        @Override
        public int compareTo(SnapshotEntry o) {
            int retval = Long.compare(this.totalDistance(), o.totalDistance());
            if (retval != 0) {
                return retval;
            }
            retval = this.position.compareTo(o.position);
            if (retval != 0) {
                return retval;
            }
            return Integer.compare(System.identityHashCode(this), System.identityHashCode(o));
        }

        public String toString() {
            return String.format("SnapshotEntry(position=%s, clusters=%s, distanceToPrevious=%d)", this.position, this.clusters, this.distanceToPrevious);
        }
    }

    public record ClusterEntry(String cluster, Position position) {
    }

    public record SnapshotResult(Position position, List<ClusterEntry> clusters) {
    }
}

