/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.tableview.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.api.CacheGetResult;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataCacheConfig;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.MetadataStoreTableView;
import org.apache.pulsar.metadata.api.Notification;
import org.apache.pulsar.metadata.api.NotificationType;
import org.apache.pulsar.metadata.api.extended.SessionEvent;
import org.apache.pulsar.metadata.impl.AbstractMetadataStore;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataStoreTableViewImpl<T>
implements MetadataStoreTableView<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataStoreTableViewImpl.class);
    private static final int FILL_TIMEOUT_IN_MILLIS = 300000;
    private static final long CACHE_REFRESH_FREQUENCY_IN_MILLIS = 600000L;
    private final ConcurrentMap<String, T> data;
    private final Map<String, T> immutableData;
    private final String name;
    private final MetadataStore store;
    private final MetadataCache<T> cache;
    private final Predicate<String> listenPathValidator;
    private final BiPredicate<T, T> conflictResolver;
    private final List<BiConsumer<String, T>> tailItemListeners;
    private final List<BiConsumer<String, T>> existingItemListeners;
    private final List<BiConsumer<String, T>> outdatedItemListeners;
    private final boolean clearUntrustedData;
    private final long timeoutInMillis;
    private final String pathPrefix;
    private final Consumer<Throwable> tableViewShutDownListener;

    @Deprecated
    public MetadataStoreTableViewImpl(@NonNull Class<T> clazz, @NonNull String name, @NonNull MetadataStore store, @NonNull String pathPrefix, @NonNull BiPredicate<T, T> conflictResolver, Predicate<String> listenPathValidator, List<BiConsumer<String, T>> tailItemListeners, List<BiConsumer<String, T>> existingItemListeners, long timeoutInMillis) {
        this(clazz, name, store, pathPrefix, conflictResolver, listenPathValidator, tailItemListeners, existingItemListeners, null, false, timeoutInMillis, null);
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        if (pathPrefix == null) {
            throw new NullPointerException("pathPrefix is marked non-null but is null");
        }
        if (conflictResolver == null) {
            throw new NullPointerException("conflictResolver is marked non-null but is null");
        }
    }

    public MetadataStoreTableViewImpl(@NonNull Class<T> clazz, @NonNull String name, @NonNull MetadataStore store, @NonNull String pathPrefix, @NonNull BiPredicate<T, T> conflictResolver, Predicate<String> listenPathValidator, List<BiConsumer<String, T>> tailItemListeners, List<BiConsumer<String, T>> existingItemListeners, @Nullable List<BiConsumer<String, T>> outdatedItemListeners, boolean clearUntrustedData, long timeoutInMillis, @Nullable Consumer<Throwable> tableViewShutDownListener) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        if (pathPrefix == null) {
            throw new NullPointerException("pathPrefix is marked non-null but is null");
        }
        if (conflictResolver == null) {
            throw new NullPointerException("conflictResolver is marked non-null but is null");
        }
        this.name = name;
        this.data = new ConcurrentHashMap<String, T>();
        this.immutableData = Collections.unmodifiableMap(this.data);
        this.pathPrefix = pathPrefix;
        this.conflictResolver = conflictResolver;
        this.listenPathValidator = listenPathValidator;
        this.tailItemListeners = new ArrayList<BiConsumer<String, T>>();
        if (tailItemListeners != null) {
            this.tailItemListeners.addAll(tailItemListeners);
        }
        this.existingItemListeners = new ArrayList<BiConsumer<String, T>>();
        if (existingItemListeners != null) {
            this.existingItemListeners.addAll(existingItemListeners);
        }
        this.outdatedItemListeners = new ArrayList<BiConsumer<String, T>>();
        if (outdatedItemListeners != null) {
            this.outdatedItemListeners.addAll(outdatedItemListeners);
        }
        this.clearUntrustedData = clearUntrustedData;
        this.timeoutInMillis = timeoutInMillis;
        this.store = store;
        this.tableViewShutDownListener = tableViewShutDownListener;
        this.cache = store.getMetadataCache(clazz, MetadataCacheConfig.builder().expireAfterWriteMillis(-1L).refreshAfterWriteMillis(600000L).retryBackoff(MetadataCacheConfig.NO_RETRY_BACKOFF_BUILDER).asyncReloadConsumer(this::consumeAsyncReload).build());
        store.registerListener(this::handleNotification);
        if (store instanceof AbstractMetadataStore) {
            AbstractMetadataStore abstractMetadataStore = (AbstractMetadataStore)store;
            abstractMetadataStore.registerSessionListener(this::handleSessionEvent);
        }
    }

    @Override
    public void start() throws MetadataStoreException {
        this.fill();
    }

    private void consumeAsyncReload(String path, Optional<CacheGetResult<T>> cached) {
        if (!this.isValidPath(path)) {
            return;
        }
        String key = this.getKey(path);
        T val = this.getValue(cached);
        this.handleTailItem(key, val);
    }

    private boolean isValidPath(String path) {
        return this.listenPathValidator == null || this.listenPathValidator.test(path);
    }

    private T getValue(Optional<CacheGetResult<T>> cached) {
        return cached.map(CacheGetResult::getValue).orElse(null);
    }

    boolean updateData(String key, T cur) {
        MutableBoolean updated = new MutableBoolean();
        this.data.compute(key, (k, prev) -> {
            if (Objects.equals(prev, cur)) {
                if (log.isDebugEnabled()) {
                    log.debug("{} skipped item key={} value={} prev={}", new Object[]{this.name, key, cur, prev});
                }
                updated.setValue(false);
                return prev;
            }
            updated.setValue(true);
            return cur;
        });
        return updated.booleanValue();
    }

    public void handleSessionEvent(SessionEvent sessionEvent) {
        if (CollectionUtils.isEmpty(this.outdatedItemListeners)) {
            log.warn("{} Skipped handle metadata store session event {} because does not set itemOutdatedListeners", (Object)this.name, (Object)sessionEvent);
            return;
        }
        if (sessionEvent == SessionEvent.SessionLost) {
            HashMap<String, T> snapshot = new HashMap<String, T>(this.data);
            log.warn("{} clearing owned bundles because metadata store session lost {}", (Object)this.name, snapshot);
            block2: for (Map.Entry entry : snapshot.entrySet()) {
                for (BiConsumer<String, String> biConsumer : this.outdatedItemListeners) {
                    try {
                        biConsumer.accept((String)entry.getKey(), (String)entry.getValue());
                        if (!this.clearUntrustedData) continue;
                        this.data.remove(entry.getKey());
                    }
                    catch (Throwable e) {
                        if (this.tableViewShutDownListener == null) {
                            log.warn("{} failed to listen item whose state is unknown because of metadata store session lost. key:{}, val:{}", new Object[]{this.name, entry.getKey(), entry.getValue(), e});
                            continue block2;
                        }
                        log.warn("{} Shutdown table view, because failed to listen item whose state is unknown due to metadata store session lost. key:{}, val:{}", new Object[]{this.name, entry.getKey(), entry.getValue(), e});
                        this.tableViewShutDownListener.accept(e);
                        continue block2;
                    }
                }
            }
        } else if (sessionEvent == SessionEvent.SessionReestablished) {
            log.info("{} Refilling bundle owner list after metadata store session reestablished", (Object)this.name);
            this.fillAsync(null, true).exceptionally(ex -> {
                if (this.tableViewShutDownListener == null) {
                    log.warn("{} failed to fill existing items after session reestablished", (Object)this.name, ex);
                } else {
                    log.error("{} Shutdown table view because failed to fill existing items after session reestablished", (Object)this.name, ex);
                    this.tableViewShutDownListener.accept((Throwable)ex);
                }
                return null;
            });
        }
    }

    private void handleTailItem(String key, T val) {
        if (this.updateData(key, val)) {
            if (log.isDebugEnabled()) {
                log.debug("{} applying item key={} value={}", new Object[]{this.name, key, val});
            }
            for (BiConsumer<String, String> biConsumer : this.tailItemListeners) {
                try {
                    biConsumer.accept(key, (String)val);
                }
                catch (Throwable e) {
                    log.error("{} failed to listen tail item key:{}, val:{}", new Object[]{this.name, key, val, e});
                }
            }
        }
    }

    private CompletableFuture<Void> doHandleNotification(String path) {
        if (!this.isValidPath(path)) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)this.cache.get(path).thenAccept(valOpt -> {
            String key = this.getKey(path);
            T val = valOpt.orElse(null);
            this.handleTailItem(key, val);
        })).exceptionally(e -> {
            log.error("{} failed to handle notification for path:{}", new Object[]{this.name, path, e});
            return null;
        });
    }

    private void handleNotification(Notification notification) {
        if (notification.getType() == NotificationType.ChildrenChanged) {
            return;
        }
        String path = notification.getPath();
        this.doHandleNotification(path);
    }

    private CompletableFuture<Void> handleExisting(String path) {
        if (!this.isValidPath(path)) {
            return CompletableFuture.completedFuture(null);
        }
        return this.cache.get(path).thenAccept(valOpt -> valOpt.ifPresent(val -> {
            String key = this.getKey(path);
            this.updateData(key, val);
            if (log.isDebugEnabled()) {
                log.debug("{} applying existing item key={} value={}", new Object[]{this.name, key, val});
            }
            for (BiConsumer<String, String> biConsumer : this.existingItemListeners) {
                try {
                    biConsumer.accept(key, (String)val);
                }
                catch (Throwable e) {
                    log.error("{} failed to listen existing item key:{}, val:{}", new Object[]{this.name, key, val, e});
                    throw e;
                }
            }
        }));
    }

    private void fill() throws MetadataStoreException {
        AtomicLong loadedCounter = new AtomicLong();
        long maxWaitTime = Math.min(this.timeoutInMillis, 300000L);
        try {
            this.fillAsync(loadedCounter, false).get(maxWaitTime, TimeUnit.MILLISECONDS);
            log.info("{} completed filling existing items with size:{}", (Object)this.name, (Object)loadedCounter.get());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            String err = this.name + " failed to fill existing items in " + TimeUnit.MILLISECONDS.toSeconds(maxWaitTime) + " secs. Filled count:" + loadedCounter.get();
            log.error(err);
            throw new MetadataStoreException(err, FutureUtil.unwrapCompletionException((Throwable)e));
        }
    }

    private CompletableFuture<Void> handleExistingLeafs(String rootPath, String path, @Nullable AtomicLong count, boolean printDetails) {
        return this.store.getChildren(path).thenCompose(children -> {
            if (children.isEmpty()) {
                if (rootPath.equals(path)) {
                    return CompletableFuture.completedFuture(null);
                }
                if (count != null) {
                    count.incrementAndGet();
                }
                if (printDetails) {
                    log.info("handling exist leaf {}", (Object)path);
                }
                return this.handleExisting(path);
            }
            if (printDetails) {
                log.info("handling exist dir {}", (Object)path);
            }
            ArrayList<CompletableFuture<Void>> futureList = new ArrayList<CompletableFuture<Void>>();
            for (String child : children) {
                futureList.add(this.handleExistingLeafs(rootPath, path + "/" + child, count, printDetails));
            }
            return FutureUtil.waitForAll(futureList);
        });
    }

    private CompletableFuture<Void> fillAsync(@Nullable AtomicLong loadedCounter, boolean printDetails) {
        return this.handleExistingLeafs(this.pathPrefix, this.pathPrefix, loadedCounter, printDetails);
    }

    private String getPath(String key) {
        return this.pathPrefix + "/" + key;
    }

    private String getKey(String path) {
        return path.replaceFirst(this.pathPrefix + "/", "");
    }

    public boolean exists(String key) {
        return this.immutableData.containsKey(key);
    }

    @Override
    public T get(String key) {
        return (T)this.data.get(key);
    }

    @Override
    public CompletableFuture<Void> put(String key, T value) {
        String path = this.getPath(key);
        return ((CompletableFuture)this.cache.readModifyUpdateOrCreate(path, old -> {
            if (this.conflictResolver.test(old.orElse(null), value)) {
                return value;
            }
            throw new MetadataStoreTableView.ConflictException(String.format("Failed to update from old:%s to value:%s", old, value));
        }).thenCompose(__ -> this.doHandleNotification(path))).exceptionally(e -> {
            if (e.getCause() instanceof MetadataStoreException.BadVersionException) {
                throw FutureUtil.wrapToCompletionException((Throwable)new MetadataStoreTableView.ConflictException(String.format("Failed to update to value:%s", value)));
            }
            throw FutureUtil.wrapToCompletionException((Throwable)e.getCause());
        });
    }

    @Override
    public CompletableFuture<Void> delete(String key) {
        String path = this.getPath(key);
        return this.cache.delete(path).thenCompose(__ -> this.doHandleNotification(path));
    }

    public int size() {
        return this.immutableData.size();
    }

    public boolean isEmpty() {
        return this.immutableData.isEmpty();
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.immutableData.entrySet();
    }

    public Set<String> keySet() {
        return this.immutableData.keySet();
    }

    public Collection<T> values() {
        return this.immutableData.values();
    }

    public void forEach(BiConsumer<String, T> action) {
        this.immutableData.forEach(action);
    }

    @Generated
    public static <T> MetadataStoreTableViewImplBuilder<T> builder() {
        return new MetadataStoreTableViewImplBuilder();
    }

    @Generated
    public static class MetadataStoreTableViewImplBuilder<T> {
        @Generated
        private Class<T> clazz;
        @Generated
        private String name;
        @Generated
        private MetadataStore store;
        @Generated
        private String pathPrefix;
        @Generated
        private BiPredicate<T, T> conflictResolver;
        @Generated
        private Predicate<String> listenPathValidator;
        @Generated
        private List<BiConsumer<String, T>> tailItemListeners;
        @Generated
        private List<BiConsumer<String, T>> existingItemListeners;
        @Generated
        private long timeoutInMillis;
        @Generated
        private List<BiConsumer<String, T>> outdatedItemListeners;
        @Generated
        private boolean clearUntrustedData;
        @Generated
        private Consumer<Throwable> tableViewShutDownListener;

        @Generated
        MetadataStoreTableViewImplBuilder() {
        }

        @Generated
        public MetadataStoreTableViewImplBuilder<T> clazz(@NonNull Class<T> clazz) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            this.clazz = clazz;
            return this;
        }

        @Generated
        public MetadataStoreTableViewImplBuilder<T> name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public MetadataStoreTableViewImplBuilder<T> store(@NonNull MetadataStore store) {
            if (store == null) {
                throw new NullPointerException("store is marked non-null but is null");
            }
            this.store = store;
            return this;
        }

        @Generated
        public MetadataStoreTableViewImplBuilder<T> pathPrefix(@NonNull String pathPrefix) {
            if (pathPrefix == null) {
                throw new NullPointerException("pathPrefix is marked non-null but is null");
            }
            this.pathPrefix = pathPrefix;
            return this;
        }

        @Generated
        public MetadataStoreTableViewImplBuilder<T> conflictResolver(@NonNull BiPredicate<T, T> conflictResolver) {
            if (conflictResolver == null) {
                throw new NullPointerException("conflictResolver is marked non-null but is null");
            }
            this.conflictResolver = conflictResolver;
            return this;
        }

        @Generated
        public MetadataStoreTableViewImplBuilder<T> listenPathValidator(Predicate<String> listenPathValidator) {
            this.listenPathValidator = listenPathValidator;
            return this;
        }

        @Generated
        public MetadataStoreTableViewImplBuilder<T> tailItemListeners(List<BiConsumer<String, T>> tailItemListeners) {
            this.tailItemListeners = tailItemListeners;
            return this;
        }

        @Generated
        public MetadataStoreTableViewImplBuilder<T> existingItemListeners(List<BiConsumer<String, T>> existingItemListeners) {
            this.existingItemListeners = existingItemListeners;
            return this;
        }

        @Generated
        public MetadataStoreTableViewImplBuilder<T> timeoutInMillis(long timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
            return this;
        }

        @Generated
        public MetadataStoreTableViewImpl<T> build() {
            return new MetadataStoreTableViewImpl<T>(this.clazz, this.name, this.store, this.pathPrefix, this.conflictResolver, this.listenPathValidator, this.tailItemListeners, this.existingItemListeners, this.timeoutInMillis);
        }

        @Generated
        public String toString() {
            return "MetadataStoreTableViewImpl.MetadataStoreTableViewImplBuilder(clazz=" + String.valueOf(this.clazz) + ", name=" + this.name + ", store=" + String.valueOf(this.store) + ", pathPrefix=" + this.pathPrefix + ", conflictResolver=" + String.valueOf(this.conflictResolver) + ", listenPathValidator=" + String.valueOf(this.listenPathValidator) + ", tailItemListeners=" + String.valueOf(this.tailItemListeners) + ", existingItemListeners=" + String.valueOf(this.existingItemListeners) + ", timeoutInMillis=" + this.timeoutInMillis + ")";
        }

        @Generated
        public MetadataStoreTableViewImplBuilder<T> outdatedItemListeners(@Nullable List<BiConsumer<String, T>> outdatedItemListeners) {
            this.outdatedItemListeners = outdatedItemListeners;
            return this;
        }

        @Generated
        public MetadataStoreTableViewImplBuilder<T> clearUntrustedData(boolean clearUntrustedData) {
            this.clearUntrustedData = clearUntrustedData;
            return this;
        }

        @Generated
        public MetadataStoreTableViewImplBuilder<T> tableViewShutDownListener(@Nullable Consumer<Throwable> tableViewShutDownListener) {
            this.tableViewShutDownListener = tableViewShutDownListener;
            return this;
        }
    }
}

