/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.TypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;

public class FloatTypeConstructor
implements TypeConstructor<Float> {
    private static final FloatTypeConstructor INSTANCE = new FloatTypeConstructor();

    public static FloatTypeConstructor getInstance() {
        return INSTANCE;
    }

    private FloatTypeConstructor() {
    }

    @Override
    public Float construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (in.hasRemaining(4)) {
            return Float.valueOf(in.getFloat());
        }
        throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Cannot construct float: insufficient input data", new Object[0]);
    }
}

