/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh.election;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.shell.cli.sh.command.AbstractRatisCommand;
import org.apache.ratis.shell.cli.sh.command.Context;

public class PauseCommand
extends AbstractRatisCommand {
    public static final String ADDRESS_OPTION_NAME = "address";

    public PauseCommand(Context context) {
        super(context);
    }

    @Override
    public String getCommandName() {
        return "pause";
    }

    @Override
    public int run(CommandLine cl) throws IOException {
        super.run(cl);
        String strAddr = cl.getOptionValue(ADDRESS_OPTION_NAME);
        RaftPeerId peerId = this.getRaftGroup().getPeers().stream().filter(p -> p.getAddress().equals(strAddr)).findAny().map(RaftPeer::getId).orElse(null);
        if (peerId == null) {
            this.printf("Peer not found: %s", strAddr);
            return -1;
        }
        try (RaftClient raftClient = this.newRaftClient();){
            RaftClientReply reply = raftClient.getLeaderElectionManagementApi(peerId).pause();
            this.processReply(reply, () -> String.format("Failed to pause leader election on peer %s", strAddr));
            this.printf(String.format("Successful pause leader election on peer %s", strAddr), new Object[0]);
        }
        return 0;
    }

    @Override
    public String getUsage() {
        return String.format("%s -%s <HOSTNAME:PORT> -%s <PEER0_HOST:PEER0_PORT,PEER1_HOST:PEER1_PORT,PEER2_HOST:PEER2_PORT> [-%s <RAFT_GROUP_ID>]", this.getCommandName(), ADDRESS_OPTION_NAME, "peers", "groupid");
    }

    @Override
    public String getDescription() {
        return PauseCommand.description();
    }

    @Override
    public Options getOptions() {
        return super.getOptions().addOption(Option.builder().option(ADDRESS_OPTION_NAME).hasArg().required().desc("Server address that will be paused its leader election").build());
    }

    public static String description() {
        return "Pause leader election to the server <hostname>:<port>";
    }
}

