/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.scalar;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.InputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.Type;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.base.DynamicEnum;
import org.apache.servicecomb.foundation.common.utils.bean.IntSetter;
import org.apache.servicecomb.foundation.common.utils.bean.Setter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.EnumMeta;

public class EnumsReadSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        JavaType javaType = propertyDescriptor.getJavaType();
        if (javaType.isEnumType()) {
            return new EnumSchema(protoField, propertyDescriptor);
        }
        if (Integer.class.equals((Object)javaType.getRawClass()) || javaType.isJavaLangObject()) {
            return new IntEnumSchema(protoField, propertyDescriptor);
        }
        if (Integer.TYPE.equals(javaType.getRawClass())) {
            return new IntPrimitiveEnumSchema(protoField, propertyDescriptor);
        }
        if (javaType.isTypeOrSubTypeOf(DynamicEnum.class)) {
            return new DynamicEnumSchema(protoField, propertyDescriptor);
        }
        ProtoUtils.throwNotSupportMerge(protoField, propertyDescriptor.getJavaType());
        return null;
    }

    private static class IntPrimitiveEnumSchema<T>
    extends FieldSchema<T> {
        private final IntSetter<T> setter;

        public IntPrimitiveEnumSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
            this.setter = (IntSetter)propertyDescriptor.getSetter();
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            int value = input.readInt32();
            this.setter.set(message, value);
            return input.readFieldNumber();
        }
    }

    private static class IntEnumSchema<T>
    extends FieldSchema<T> {
        private final Setter<T, Integer> setter;

        public IntEnumSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
            this.setter = (Setter)propertyDescriptor.getSetter();
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            int value = input.readInt32();
            this.setter.set(message, (Object)value);
            return input.readFieldNumber();
        }
    }

    private static class DynamicEnumSchema<T>
    extends FieldSchema<T> {
        public DynamicEnumSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            throw new IllegalStateException(String.format("currently, protobuf not support dynamic enum, type=%s, proto field=%s:%s", this.javaType.getRawClass().getName(), ((Type)this.protoField.getParent()).getCanonicalName(), this.protoField.getName()));
        }
    }

    private static class EnumSchema<T>
    extends FieldSchema<T> {
        private final Setter<T, Enum<?>> setter;
        private final EnumMeta enumMeta;

        public EnumSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
            this.setter = (Setter)propertyDescriptor.getSetter();
            this.enumMeta = new EnumMeta(protoField, this.javaType);
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            int value = input.readInt32();
            Enum<?> enumValue = this.enumMeta.getEnumByValue(value);
            if (enumValue != null) {
                this.setter.set(message, enumValue);
                return input.readFieldNumber();
            }
            throw new IllegalStateException(String.format("invalid enum value %d for %s, proto field=%s:%s", value, this.javaType.getRawClass().getName(), ((Type)this.protoField.getParent()).getCanonicalName(), this.protoField.getName()));
        }
    }
}

