/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.http;

import com.google.common.annotations.VisibleForTesting;
import io.vertx.core.buffer.Buffer;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.foundation.vertx.http.BodyBufferSupport;

public class BodyBufferSupportImpl
implements BodyBufferSupport {
    protected Buffer bodyBuffer;
    private byte[] bodyBytes;
    private int bodyLength;

    @Override
    public void setBodyBuffer(Buffer bodyBuffer) {
        this.bodyBuffer = bodyBuffer;
        this.bodyBytes = null;
        this.bodyLength = 0;
    }

    private void prepare() {
        if (this.bodyBytes == null && this.bodyBuffer != null) {
            this.bodyLength = this.bodyBuffer.length();
            this.bodyBytes = VertxUtils.getBytesFast(this.bodyBuffer);
        }
    }

    @Override
    public Buffer getBodyBuffer() {
        return this.bodyBuffer;
    }

    @VisibleForTesting
    void setBodyBytes(byte[] bodyBytes) {
        this.bodyBytes = bodyBytes;
    }

    @Override
    public byte[] getBodyBytes() {
        this.prepare();
        return this.bodyBytes;
    }

    @VisibleForTesting
    void setBodyLength(int bodyLength) {
        this.bodyLength = bodyLength;
    }

    @Override
    public int getBodyBytesLength() {
        this.prepare();
        return this.bodyLength;
    }
}

