/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.executor.facade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.kernel.executor.facade.AbstractJobFacade;
import org.apache.shardingsphere.elasticjob.kernel.internal.config.ConfigurationService;
import org.apache.shardingsphere.elasticjob.kernel.internal.failover.FailoverService;
import org.apache.shardingsphere.elasticjob.kernel.internal.instance.InstanceService;
import org.apache.shardingsphere.elasticjob.kernel.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.ExecutionContextService;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.ExecutionService;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.ShardingService;
import org.apache.shardingsphere.elasticjob.kernel.internal.storage.JobNodeStorage;
import org.apache.shardingsphere.elasticjob.kernel.tracing.config.TracingConfiguration;
import org.apache.shardingsphere.elasticjob.kernel.tracing.event.JobTracingEventBus;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.spi.listener.ElasticJobListener;
import org.apache.shardingsphere.elasticjob.spi.listener.param.ShardingContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SingleShardingJobFacade
extends AbstractJobFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SingleShardingJobFacade.class);
    private final ConfigurationService configService;
    private final ShardingService shardingService;
    private final ExecutionContextService executionContextService;
    private final ExecutionService executionService;
    private final FailoverService failoverService;
    private final Collection<ElasticJobListener> elasticJobListeners;
    private final JobTracingEventBus jobTracingEventBus;
    private final JobNodeStorage jobNodeStorage;
    private final InstanceService instanceService;

    public SingleShardingJobFacade(CoordinatorRegistryCenter regCenter, String jobName, Collection<ElasticJobListener> elasticJobListeners, TracingConfiguration<?> tracingConfig) {
        super(regCenter, jobName, elasticJobListeners, tracingConfig);
        this.configService = new ConfigurationService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.executionContextService = new ExecutionContextService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.failoverService = new FailoverService(regCenter, jobName);
        this.elasticJobListeners = elasticJobListeners.stream().sorted(Comparator.comparingInt(ElasticJobListener::order)).collect(Collectors.toList());
        this.jobTracingEventBus = null == tracingConfig ? new JobTracingEventBus() : new JobTracingEventBus(tracingConfig);
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.instanceService = new InstanceService(regCenter, jobName);
    }

    @Override
    public void registerJobCompleted(ShardingContexts shardingContexts) {
        super.registerJobCompleted(shardingContexts);
        JobConfiguration jobConfig = this.configService.load(true);
        JobInstance jobInst = JobRegistry.getInstance().getJobInstance(jobConfig.getJobName());
        if (null == jobInst) {
            log.warn("Error! Can't find the job instance with name:{}", (Object)jobConfig.getJobName());
            return;
        }
        Integer nextIndex = null;
        List<JobInstance> availJobInst = this.instanceService.getAvailableJobInstances();
        for (int i = 0; i < availJobInst.size(); ++i) {
            JobInstance temp = availJobInst.get(i);
            if (!temp.getServerIp().equals(jobInst.getServerIp())) continue;
            nextIndex = i + 1;
            break;
        }
        if (nextIndex != null) {
            nextIndex = nextIndex >= availJobInst.size() ? 0 : nextIndex;
            this.jobNodeStorage.fillEphemeralJobNode("next-job-instance-ip", availJobInst.get(nextIndex).getServerIp());
        }
        if (log.isDebugEnabled()) {
            log.debug("job name: {}, next index: {}, sharding total count: {}", new Object[]{jobConfig.getJobName(), nextIndex, jobConfig.getShardingTotalCount()});
        }
    }

    @Override
    public ShardingContexts getShardingContexts() {
        List<Integer> shardingItems;
        List<Integer> failoverShardingItems;
        JobConfiguration jobConfig = this.configService.load(true);
        boolean isFailover = jobConfig.isFailover();
        if (isFailover && !(failoverShardingItems = this.failoverService.getLocalFailoverItems()).isEmpty()) {
            return this.executionContextService.getJobShardingContext(failoverShardingItems);
        }
        String nextJobInstIP = null;
        if (this.isNeedSharding()) {
            this.shardingService.shardingIfNecessary();
            shardingItems = this.shardingService.getLocalShardingItems();
        } else {
            nextJobInstIP = this.jobNodeStorage.getJobNodeDataDirectly("next-job-instance-ip");
            if (StringUtils.isBlank((CharSequence)nextJobInstIP)) {
                this.shardingService.shardingIfNecessary();
                shardingItems = this.shardingService.getLocalShardingItems();
            } else {
                JobInstance jobInst = JobRegistry.getInstance().getJobInstance(jobConfig.getJobName());
                List<Object> list = shardingItems = nextJobInstIP.equals(jobInst.getServerIp()) ? Collections.singletonList(0) : new ArrayList();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("job name: {}, sharding items: {}, nextJobInstIP: {}, sharding total count: {}, isFailover: {}", new Object[]{jobConfig.getJobName(), shardingItems, nextJobInstIP, jobConfig.getShardingTotalCount(), isFailover});
        }
        if (isFailover) {
            shardingItems.removeAll(this.failoverService.getLocalTakeOffItems());
        }
        shardingItems.removeAll(this.executionService.getDisabledItems(shardingItems));
        return this.executionContextService.getJobShardingContext(shardingItems);
    }
}

