/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.registry.api.config;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class RegisterConfig {
    private boolean enabled;
    private String registerType;
    private String serverLists;
    private Properties props = new Properties();

    public RegisterConfig() {
    }

    public RegisterConfig(String registerType, String serverLists, Properties props) {
        this.registerType = registerType;
        this.serverLists = serverLists;
        this.props = props;
    }

    public String getRegisterType() {
        return this.registerType;
    }

    public void setRegisterType(String registerType) {
        this.registerType = registerType;
    }

    public String getServerLists() {
        return this.serverLists;
    }

    public void setServerLists(String serverLists) {
        this.serverLists = serverLists;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object obj) {
        if (Objects.isNull(obj)) {
            return false;
        }
        RegisterConfig registerConfig = (RegisterConfig)obj;
        if (!this.getRegisterType().equals(registerConfig.getRegisterType())) {
            return false;
        }
        if (!this.getServerLists().equals(registerConfig.getServerLists())) {
            return false;
        }
        Properties properties = this.getProps();
        Properties registerConfigProps = registerConfig.getProps();
        if (Objects.isNull(properties) && Objects.isNull(registerConfigProps)) {
            return true;
        }
        if (Objects.isNull(properties) || Objects.isNull(registerConfigProps)) {
            return false;
        }
        if (properties.entrySet().size() != registerConfigProps.entrySet().size()) {
            return false;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object oldValue;
            Object newValue = entry.getValue();
            if (newValue.equals(oldValue = registerConfigProps.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        String registerTypeStr = this.getRegisterType();
        int result = StringUtils.isNotEmpty((CharSequence)registerTypeStr) ? registerTypeStr.hashCode() : 0;
        String serverListsStr = this.getServerLists();
        result = 31 * result + (StringUtils.isNotEmpty((CharSequence)serverListsStr) ? serverListsStr.hashCode() : 0);
        Properties properties = this.getProps();
        if (Objects.nonNull(properties)) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object entryKey = entry.getKey();
                result = 31 * result + (Objects.nonNull(entryKey) ? entryKey.hashCode() : 0);
                Object entryValue = entry.getValue();
                result = 31 * result + (Objects.nonNull(entryValue) ? entryValue.hashCode() : 0);
            }
        }
        return result;
    }

    public static final class Builder {
        private boolean enabled;
        private String registerType;
        private String serverLists;
        private Properties props;

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder registerType(String registerType) {
            this.registerType = registerType;
            return this;
        }

        public Builder serverLists(String serverLists) {
            this.serverLists = serverLists;
            return this;
        }

        public Builder props(Properties props) {
            this.props = props;
            return this;
        }

        public RegisterConfig build() {
            RegisterConfig registerConfig = new RegisterConfig();
            registerConfig.setEnabled(this.enabled);
            registerConfig.setRegisterType(this.registerType);
            registerConfig.setServerLists(this.serverLists);
            registerConfig.setProps(this.props);
            return registerConfig;
        }
    }
}

