/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.config.properties.ClusterProperties;
import org.apache.shenyu.admin.config.properties.ClusterZookeeperProperties;
import org.apache.shenyu.admin.mode.cluster.impl.jdbc.ClusterSelectMasterServiceJdbcImpl;
import org.apache.shenyu.admin.mode.cluster.impl.jdbc.mapper.ClusterMasterMapper;
import org.apache.shenyu.admin.mode.cluster.service.ClusterSelectMasterService;
import org.apache.shenyu.common.utils.IpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.jdbc.lock.DefaultLockRepository;
import org.springframework.integration.jdbc.lock.JdbcLockRegistry;
import org.springframework.integration.jdbc.lock.LockRepository;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ClusterProperties.class, ClusterZookeeperProperties.class})
@ConditionalOnProperty(value={"shenyu.cluster.type"}, havingValue="jdbc", matchIfMissing=true)
public class ClusterJdbcConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterJdbcConfiguration.class);
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;
    @Value(value="${server.port:}")
    private String port;

    @Bean
    public DefaultLockRepository defaultLockRepository(DataSource dataSource, ClusterProperties clusterProperties) {
        String host = IpUtils.getHost();
        String fullPath = host + ":" + this.port;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.contextPath})) {
            fullPath = fullPath + this.contextPath;
        }
        DefaultLockRepository defaultLockRepository = new DefaultLockRepository(dataSource, fullPath);
        defaultLockRepository.setPrefix("SHENYU_");
        long millis = TimeUnit.SECONDS.toMillis(clusterProperties.getLockTtl());
        defaultLockRepository.setTimeToLive(Long.valueOf(millis).intValue());
        return defaultLockRepository;
    }

    @Bean
    public JdbcLockRegistry jdbcLockRegistry(LockRepository lockRepository) {
        return new JdbcLockRegistry(lockRepository);
    }

    @Bean
    public ClusterSelectMasterService clusterSelectMasterJdbcService(ClusterProperties clusterProperties, JdbcLockRegistry jdbcLockRegistry, ClusterMasterMapper clusterMasterMapper) {
        return new ClusterSelectMasterServiceJdbcImpl(clusterProperties, jdbcLockRegistry, clusterMasterMapper);
    }
}

