/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import org.apache.shenyu.admin.mode.ShenyuRunningModeService;
import org.apache.shenyu.admin.mode.standalone.ShenyuStandaloneService;
import org.apache.shenyu.admin.service.impl.InstanceCheckService;
import org.apache.shenyu.admin.service.impl.UpstreamCheckService;
import org.apache.shenyu.admin.service.manager.LoadServiceDocEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class StandaloneConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneConfiguration.class);

    @Bean(destroyMethod="shutdown")
    @ConditionalOnProperty(value={"shenyu.cluster.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean
    public ShenyuRunningModeService shenyuRunningModeService(UpstreamCheckService upstreamCheckService, InstanceCheckService instanceCheckService, LoadServiceDocEntry loadServiceDocEntry) {
        LOGGER.info("starting in standalone mode ...");
        return new ShenyuStandaloneService(upstreamCheckService, loadServiceDocEntry, instanceCheckService);
    }
}

