/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import com.google.common.collect.Maps;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.exception.ShenyuAdminException;
import org.apache.shenyu.admin.listener.http.HttpLongPollingDataChangedListener;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.NamespaceVO;
import org.apache.shenyu.admin.service.NamespaceService;
import org.apache.shenyu.common.dto.ConfigData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ResponseBody
@RequestMapping(value={"/configs"})
@ConditionalOnProperty(prefix="shenyu.sync.http", name={"enabled"}, havingValue="true")
public class ConfigController {
    private final HttpLongPollingDataChangedListener httpLongPollingDataChangedListener;
    private final NamespaceService namespaceService;

    public ConfigController(HttpLongPollingDataChangedListener httpLongPollingDataChangedListener, NamespaceService namespaceService) {
        this.httpLongPollingDataChangedListener = httpLongPollingDataChangedListener;
        this.namespaceService = namespaceService;
    }

    @GetMapping(value={"/fetch"})
    public ShenyuAdminResult fetchConfigs(@NotNull String[] groupKeys, String namespaceId) {
        if (StringUtils.isEmpty((CharSequence)namespaceId)) {
            throw new ShenyuAdminException("namespaceId is null");
        }
        NamespaceVO existNamespace = this.namespaceService.findByNamespaceId(namespaceId);
        if (StringUtils.isNotEmpty((CharSequence)namespaceId) && ObjectUtils.isEmpty((Object)existNamespace)) {
            throw new ShenyuAdminException("namespace is not exist");
        }
        HashMap result = Maps.newHashMap();
        for (String groupKey : groupKeys) {
            ConfigData<?> data = this.httpLongPollingDataChangedListener.fetchConfig(ConfigGroupEnum.valueOf((String)groupKey), namespaceId);
            result.put(groupKey, data);
        }
        return ShenyuAdminResult.success("success", result);
    }

    @PostMapping(value={"/listener"})
    public void listener(HttpServletRequest request, HttpServletResponse response) {
        this.httpLongPollingDataChangedListener.doLongPolling(request, response);
    }
}

