/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shenyu.admin.exception.ShenyuAdminException;
import org.apache.shenyu.admin.mapper.NamespaceUserRelMapper;
import org.apache.shenyu.admin.model.entity.NamespaceDO;
import org.apache.shenyu.admin.model.entity.NamespaceUserRelDO;
import org.apache.shenyu.admin.model.event.namespace.NamespaceCreatedEvent;
import org.apache.shenyu.admin.model.vo.NamespaceUserRelVO;
import org.apache.shenyu.admin.service.NamespaceUserService;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class NamespaceUserServiceImpl
implements NamespaceUserService {
    private final NamespaceUserRelMapper namespaceUserRelMapper;

    public NamespaceUserServiceImpl(NamespaceUserRelMapper namespaceUserRelMapper) {
        this.namespaceUserRelMapper = namespaceUserRelMapper;
    }

    @Override
    public NamespaceUserRelVO create(String namespaceId, String userId) {
        NamespaceUserRelDO existNamespaceUserRelDO = this.namespaceUserRelMapper.selectByNamespaceIdAndUserId(namespaceId, userId);
        if (!Objects.isNull(existNamespaceUserRelDO)) {
            throw new ShenyuAdminException("The user namespace rel is exist\uff01");
        }
        String uuid = UUIDUtils.getInstance().generateShortUuid();
        NamespaceUserRelDO namespaceUserRelDO = NamespaceUserRelDO.builder().id(uuid).namespaceId(namespaceId).userId(userId).build();
        this.namespaceUserRelMapper.insertSelective(namespaceUserRelDO);
        return NamespaceUserRelVO.builder().id(uuid).namespaceId(namespaceId).userId(userId).build();
    }

    @Override
    public List<String> listNamespaceIdByUserId(String userId) {
        List<NamespaceUserRelDO> namespaceUserRelDOS = this.namespaceUserRelMapper.selectListByUserId(userId);
        if (Objects.isNull(namespaceUserRelDOS)) {
            return Lists.newArrayList();
        }
        return namespaceUserRelDOS.stream().map(NamespaceUserRelDO::getNamespaceId).collect(Collectors.toList());
    }

    @EventListener(value={NamespaceCreatedEvent.class})
    public void onNamespaceCreated(NamespaceCreatedEvent event) {
        NamespaceDO namespaceDO = (NamespaceDO)event.getSource();
        if (Objects.isNull(namespaceDO)) {
            return;
        }
        this.create(namespaceDO.getNamespaceId(), event.getUserId());
    }
}

