/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.mapper.PluginHandleMapper;
import org.apache.shenyu.admin.mapper.ShenyuDictMapper;
import org.apache.shenyu.admin.model.dto.PluginHandleDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.PluginHandleDO;
import org.apache.shenyu.admin.model.event.plugin.BatchPluginDeletedEvent;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.PluginHandleQuery;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.model.vo.PluginHandleVO;
import org.apache.shenyu.admin.model.vo.ShenyuDictVO;
import org.apache.shenyu.admin.service.PluginHandleService;
import org.apache.shenyu.admin.service.configs.ConfigsImportContext;
import org.apache.shenyu.admin.service.publish.PluginHandleEventPublisher;
import org.apache.shenyu.common.utils.ListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PluginHandleServiceImpl
implements PluginHandleService {
    private static final Logger LOG = LoggerFactory.getLogger(PluginHandleServiceImpl.class);
    private static final int SELECT_BOX_DATA_TYPE = 3;
    private final PluginHandleMapper pluginHandleMapper;
    private final ShenyuDictMapper shenyuDictMapper;
    private final PluginHandleEventPublisher eventPublisher;

    public PluginHandleServiceImpl(PluginHandleMapper pluginHandleMapper, ShenyuDictMapper shenyuDictMapper, PluginHandleEventPublisher eventPublisher) {
        this.pluginHandleMapper = pluginHandleMapper;
        this.shenyuDictMapper = shenyuDictMapper;
        this.eventPublisher = eventPublisher;
    }

    @Override
    @Pageable
    public CommonPager<PluginHandleVO> listByPage(PluginHandleQuery pluginHandleQuery) {
        List<PluginHandleDO> pluginHandleDOList = this.pluginHandleMapper.selectByQuery(pluginHandleQuery);
        return PageResultUtils.result(pluginHandleQuery.getPageParameter(), () -> this.buildPluginHandleVO(pluginHandleDOList));
    }

    @Override
    public Integer create(PluginHandleDTO pluginHandleDTO) {
        PluginHandleDO pluginHandleDO = PluginHandleDO.buildPluginHandleDO(pluginHandleDTO);
        int pluginHandleCount = this.pluginHandleMapper.insertSelective(pluginHandleDO);
        if (pluginHandleCount > 0) {
            this.eventPublisher.onCreated(pluginHandleDO);
        }
        return pluginHandleCount;
    }

    @Override
    public Integer update(PluginHandleDTO pluginHandleDTO) {
        PluginHandleDO pluginHandleDO = PluginHandleDO.buildPluginHandleDO(pluginHandleDTO);
        PluginHandleDO before = this.pluginHandleMapper.selectById(pluginHandleDTO.getId());
        int pluginHandleCount = this.pluginHandleMapper.updateByPrimaryKeySelective(pluginHandleDO);
        if (pluginHandleCount > 0) {
            this.eventPublisher.onUpdated(pluginHandleDO, before);
        }
        return pluginHandleCount;
    }

    @Override
    public Integer deletePluginHandles(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return 0;
        }
        List<PluginHandleDO> handles = this.pluginHandleMapper.selectByIdList(ids);
        int count = this.pluginHandleMapper.deleteByIdList(ids);
        if (count > 0) {
            this.eventPublisher.onDeleted((Collection<PluginHandleDO>)handles);
        }
        return count;
    }

    @Override
    public PluginHandleVO findById(String id) {
        return this.buildPluginHandleVO(this.pluginHandleMapper.selectById(id));
    }

    @Override
    public List<PluginHandleVO> list(String pluginId, Integer type) {
        List<PluginHandleDO> pluginHandleDOList = this.pluginHandleMapper.selectByQuery(PluginHandleQuery.builder().pluginId(pluginId).type(type).build());
        return this.buildPluginHandleVO(pluginHandleDOList);
    }

    @Override
    public List<PluginHandleVO> listAllData() {
        List<PluginHandleDO> pluginHandleDOList = this.pluginHandleMapper.selectByQuery(PluginHandleQuery.builder().build());
        return this.buildPluginHandleVO(pluginHandleDOList);
    }

    @Override
    public List<PluginHandleVO> listAllDataByPluginIds(Collection<String> pluginIds) {
        List<PluginHandleDO> pluginHandleDOList = this.pluginHandleMapper.selectByPluginIds(pluginIds);
        if (CollectionUtils.isEmpty(pluginHandleDOList)) {
            return Lists.newArrayList();
        }
        return this.buildPluginHandleVO(pluginHandleDOList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ConfigImportResult importData(List<PluginHandleDTO> pluginHandleList, ConfigsImportContext context) {
        Map<String, List<PluginHandleVO>> existHandleMap = this.listAllData().stream().filter(Objects::nonNull).collect(Collectors.groupingBy(PluginHandleVO::getPluginId));
        Map<String, List<PluginHandleDTO>> importHandleMap = pluginHandleList.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(PluginHandleDTO::getPluginId));
        int successCount = 0;
        for (Map.Entry<String, List<PluginHandleDTO>> pluginHandleEntry : importHandleMap.entrySet()) {
            List<PluginHandleDTO> handles;
            String pluginId = context.getPluginTemplateIdMapping().get(pluginHandleEntry.getKey());
            if (StringUtils.isEmpty((CharSequence)pluginId) || !CollectionUtils.isNotEmpty(handles = pluginHandleEntry.getValue())) continue;
            if (existHandleMap.containsKey(pluginId)) {
                List<PluginHandleVO> existHandles = existHandleMap.getOrDefault(pluginId, Lists.newArrayList());
                Set handleFiledMap = existHandles.stream().map(PluginHandleVO::getField).collect(Collectors.toSet());
                for (PluginHandleDTO handle : handles) {
                    if (handleFiledMap.contains(handle.getField())) continue;
                    handle.setPluginId(pluginId);
                    this.create(handle);
                    ++successCount;
                }
                continue;
            }
            for (PluginHandleDTO handle : handles) {
                handle.setPluginId(pluginId);
                this.create(handle);
                ++successCount;
            }
        }
        return ConfigImportResult.success(successCount);
    }

    @EventListener(value={BatchPluginDeletedEvent.class})
    public void onPluginDeleted(BatchPluginDeletedEvent event) {
        this.deletePluginHandles(ListUtil.map(this.pluginHandleMapper.selectByPluginIdList(event.getDeletedPluginIds()), BaseDO::getId));
    }

    private PluginHandleVO buildPluginHandleVO(PluginHandleDO pluginHandleDO) {
        List<ShenyuDictVO> dictOptions = null;
        if (pluginHandleDO.getDataType() == 3) {
            dictOptions = this.shenyuDictMapper.findByType(pluginHandleDO.getField()).stream().filter(item -> Objects.equals(item.getEnabled(), Boolean.TRUE)).map(ShenyuDictVO::buildShenyuDictVO).toList();
        }
        return PluginHandleVO.buildPluginHandleVO(pluginHandleDO, dictOptions);
    }

    private List<PluginHandleVO> buildPluginHandleVO(List<PluginHandleDO> pluginHandleDOList) {
        List<String> fieldList = pluginHandleDOList.stream().filter(pluginHandleDO -> pluginHandleDO.getDataType() == 3).map(PluginHandleDO::getField).distinct().collect(Collectors.toList());
        HashMap shenyuDictMap = CollectionUtils.isNotEmpty(fieldList) ? Optional.ofNullable(this.shenyuDictMapper.findByTypeBatch(fieldList)).orElseGet(ArrayList::new).stream().filter(item -> Objects.equals(item.getEnabled(), Boolean.TRUE)).map(ShenyuDictVO::buildShenyuDictVO).collect(Collectors.groupingBy(ShenyuDictVO::getType)) : new HashMap(0);
        return pluginHandleDOList.stream().map(pluginHandleDO -> {
            List dictOptions = (List)shenyuDictMap.get(pluginHandleDO.getField());
            return PluginHandleVO.buildPluginHandleVO(pluginHandleDO, dictOptions);
        }).collect(Collectors.toList());
    }
}

